/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.adapter;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.mbari.vcr4j.VCRStateAdapter;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoState;

public class VCRStateFacade<S extends VideoState, E extends VideoError>
extends VCRStateAdapter {
    private final AtomicReference<S> videoState = new AtomicReference();

    public VCRStateFacade(VideoIO<S, E> videoIO) {
        videoIO.getStateObservable().forEach(s -> {
            this.videoState.set(s);
            this.os.notify((Object)this, null);
        });
    }

    @Override
    public boolean isConnected() {
        return this.apply(() -> ((VideoState)this.videoState.get()).isConnected());
    }

    @Override
    public boolean isCueingUp() {
        return this.apply(() -> ((VideoState)this.videoState.get()).isCueingUp());
    }

    @Override
    public boolean isFastForwarding() {
        return this.apply(() -> ((VideoState)this.videoState.get()).isFastForwarding());
    }

    @Override
    public boolean isPlaying() {
        return this.apply(() -> ((VideoState)this.videoState.get()).isPlaying());
    }

    @Override
    public boolean isReverseDirection() {
        return this.apply(() -> ((VideoState)this.videoState.get()).isReverseDirection());
    }

    @Override
    public boolean isRewinding() {
        return this.apply(() -> ((VideoState)this.videoState.get()).isRewinding());
    }

    @Override
    public boolean isShuttling() {
        return this.apply(() -> ((VideoState)this.videoState.get()).isShuttling());
    }

    @Override
    public boolean isStopped() {
        return this.apply(() -> ((VideoState)this.videoState.get()).isStopped());
    }

    private boolean apply(Supplier<Boolean> fn) {
        return Optional.ofNullable(fn.get()).orElse(false);
    }
}

