/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.adapter;

import org.mbari.util.IObserver;
import org.mbari.util.ObservableSupport;
import org.mbari.vcr4j.IVCRError;
import org.mbari.vcr4j.IVCRReply;
import org.mbari.vcr4j.IVCRState;
import org.mbari.vcr4j.IVCRTimecode;
import org.mbari.vcr4j.IVCRUserbits;
import org.mbari.vcr4j.VCRTimecodeAdapter;
import org.mbari.vcr4j.VCRUserbitsAdapter;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.adapter.RS422ErrorFacade;
import org.mbari.vcr4j.adapter.RS422StateFacade;
import org.mbari.vcr4j.adapter.VCRErrorFacade;
import org.mbari.vcr4j.adapter.VCRStateFacade;
import org.mbari.vcr4j.rs422.RS422VideoIO;

public class VCRReplyFacade<S extends VideoState, E extends VideoError>
implements IVCRReply {
    private ObservableSupport os = new ObservableSupport();
    private final IVCRTimecode timecode = new VCRTimecodeAdapter();
    private final IVCRUserbits userbits = new VCRUserbitsAdapter();
    private final IVCRState state;
    private final IVCRError error;

    public VCRReplyFacade(VideoIO<S, E> videoIO) {
        RS422VideoIO rs422VideoIO;
        videoIO.getIndexObservable().forEach(vi -> vi.getTimecode().ifPresent(tc -> this.timecode.timecodeProperty().setValue(tc)));
        if (videoIO instanceof RS422VideoIO) {
            rs422VideoIO = (RS422VideoIO)videoIO;
            rs422VideoIO.getUserbitsObservable().forEach(ub -> this.userbits.setUserbits(ub.getUserbits()));
        }
        if (videoIO instanceof RS422VideoIO) {
            rs422VideoIO = (RS422VideoIO)videoIO;
            this.state = new RS422StateFacade(rs422VideoIO);
        } else {
            this.state = new VCRStateFacade<S, E>(videoIO);
        }
        if (videoIO instanceof RS422VideoIO) {
            rs422VideoIO = (RS422VideoIO)videoIO;
            this.error = new RS422ErrorFacade(rs422VideoIO);
        } else {
            this.error = new VCRErrorFacade<S, E>(videoIO);
        }
    }

    @Override
    public IVCRError getVcrError() {
        return this.error;
    }

    @Override
    public IVCRState getVcrState() {
        return this.state;
    }

    @Override
    public IVCRTimecode getVcrTimecode() {
        return this.timecode;
    }

    @Override
    public IVCRUserbits getVcrUserbits() {
        return this.userbits;
    }

    @Override
    public boolean isAck() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean isNack() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean isStatusReply() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean isTimecodeReply() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean isUserbitsReply() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void addObserver(IObserver observer) {
        this.os.add(observer);
    }

    public void removeAllObservers() {
        this.os.clear();
    }

    public void removeObserver(IObserver observer) {
        this.os.remove(observer);
    }
}

