/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.adapter;

import org.mbari.vcr4j.IVCRError;
import org.mbari.vcr4j.IVCRReply;
import org.mbari.vcr4j.IVCRState;
import org.mbari.vcr4j.IVCRTimecode;
import org.mbari.vcr4j.IVCRUserbits;
import org.mbari.vcr4j.VCRAdapter;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.adapter.VCRReplyFacade;
import org.mbari.vcr4j.commands.SeekTimecodeCmd;
import org.mbari.vcr4j.commands.ShuttleCmd;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.rs422.commands.PresetUserbitsCmd;
import org.mbari.vcr4j.rs422.commands.RS422VideoCommands;
import org.mbari.vcr4j.time.Timecode;

public class VCRFacade<S extends VideoState, E extends VideoError>
extends VCRAdapter {
    private final VideoIO<S, E> videoIO;
    private final IVCRReply reply;

    public VCRFacade(VideoIO<S, E> videoIO) {
        this.videoIO = videoIO;
        this.reply = new VCRReplyFacade<S, E>(videoIO);
    }

    @Override
    public void disconnect() {
        this.videoIO.close();
        super.disconnect();
    }

    @Override
    public void eject() {
        this.videoIO.send((VideoCommand)RS422VideoCommands.EJECT);
    }

    @Override
    public void fastForward() {
        this.videoIO.send((VideoCommand)VideoCommands.FAST_FORWARD);
    }

    @Override
    public String getConnectionName() {
        return this.videoIO.getConnectionID();
    }

    @Override
    public IVCRError getVcrError() {
        return this.reply.getVcrError();
    }

    @Override
    public IVCRReply getVcrReply() {
        return this.reply;
    }

    @Override
    public IVCRState getVcrState() {
        return this.reply.getVcrState();
    }

    @Override
    public IVCRTimecode getVcrTimecode() {
        return this.reply.getVcrTimecode();
    }

    @Override
    public IVCRUserbits getVcrUserbits() {
        return this.reply.getVcrUserbits();
    }

    @Override
    public void kill() {
        this.disconnect();
    }

    @Override
    public void pause() {
        this.videoIO.send((VideoCommand)VideoCommands.PAUSE);
    }

    @Override
    public void play() {
        this.videoIO.send((VideoCommand)VideoCommands.PLAY);
    }

    @Override
    public void presetTimecode(byte[] timecode) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void presetUserbits(byte[] userbits) {
        PresetUserbitsCmd cmd = new PresetUserbitsCmd(userbits);
        this.videoIO.send((VideoCommand)cmd);
    }

    @Override
    public void record() {
        this.videoIO.send((VideoCommand)RS422VideoCommands.RECORD);
    }

    @Override
    public void releaseTape() {
        this.videoIO.send((VideoCommand)RS422VideoCommands.RELEASE_TAPE);
    }

    @Override
    public void requestDeviceType() {
        this.videoIO.send((VideoCommand)VideoCommands.REQUEST_DEVICE_TYPE);
    }

    @Override
    public void requestLocalDisable() {
        this.videoIO.send((VideoCommand)RS422VideoCommands.REQUEST_LOCAL_DISABLE);
    }

    @Override
    public void requestLocalEnable() {
        this.videoIO.send((VideoCommand)RS422VideoCommands.REQUEST_LOCAL_ENABLE);
    }

    @Override
    public void requestLTimeCode() {
        this.videoIO.send((VideoCommand)RS422VideoCommands.REQUEST_LTIMECODE);
    }

    @Override
    public void requestLUserbits() {
        this.videoIO.send((VideoCommand)RS422VideoCommands.REQUEST_LUSERBITS);
    }

    @Override
    public void requestStatus() {
        this.videoIO.send((VideoCommand)VideoCommands.REQUEST_STATUS);
    }

    @Override
    public void requestTimeCode() {
        this.videoIO.send((VideoCommand)VideoCommands.REQUEST_TIMECODE);
    }

    @Override
    public void requestUserbits() {
        this.videoIO.send((VideoCommand)RS422VideoCommands.REQUEST_USERBITS);
    }

    @Override
    public void requestVTimeCode() {
        this.videoIO.send((VideoCommand)RS422VideoCommands.REQUEST_VTIMECODE);
    }

    @Override
    public void requestVUserbits() {
        this.videoIO.send((VideoCommand)RS422VideoCommands.REQUEST_VUSERBITS);
    }

    @Override
    public void rewind() {
        this.videoIO.send((VideoCommand)VideoCommands.REWIND);
    }

    @Override
    public void seekTimecode(byte[] timecode) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void seekTimecode(int timecode) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void seekTimecode(Timecode timecode) {
        this.videoIO.send((VideoCommand)new SeekTimecodeCmd(timecode));
    }

    @Override
    public void shuttleForward(int speed) {
        this.videoIO.send((VideoCommand)new ShuttleCmd((double)speed / 255.0));
    }

    @Override
    public void shuttleReverse(int speed) {
        this.videoIO.send((VideoCommand)new ShuttleCmd((double)speed / -255.0));
    }

    @Override
    public void stop() {
        this.videoIO.send((VideoCommand)VideoCommands.STOP);
    }

    public VideoIO<S, E> getVideoIO() {
        return this.videoIO;
    }
}

