/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.adapter;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.mbari.vcr4j.VCRErrorAdapter;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoState;

public class VCRErrorFacade<S extends VideoState, E extends VideoError>
extends VCRErrorAdapter {
    private final AtomicReference<E> videoError = new AtomicReference();

    public VCRErrorFacade(VideoIO<S, E> videoIO) {
        videoIO.getErrorObservable().forEach(e -> {
            this.videoError.set(e);
            this.oc.notify((Object)this, null);
        });
    }

    @Override
    public boolean isOK() {
        return this.apply(() -> !((VideoError)this.videoError.get()).hasError());
    }

    private boolean apply(Supplier<Boolean> fn) {
        boolean v;
        try {
            v = Optional.ofNullable(fn.get()).orElse(false);
        }
        catch (Exception e) {
            v = false;
        }
        return v;
    }
}

