/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.adapter;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.mbari.vcr4j.VCRStateAdapter;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.rs422.RS422Error;
import org.mbari.vcr4j.rs422.RS422State;

public class RS422StateFacade<S extends RS422State, E extends RS422Error>
extends VCRStateAdapter {
    private final AtomicReference<S> videoState = new AtomicReference();

    public RS422StateFacade(VideoIO<S, E> videoIO) {
        videoIO.getStateObservable().forEach(s -> {
            this.videoState.set(s);
            this.os.notify((Object)this, null);
        });
    }

    @Override
    public boolean isBadCommunication() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isBadCommunication());
    }

    @Override
    public boolean isConnected() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isConnected());
    }

    @Override
    public boolean isCueingUp() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isCueingUp());
    }

    @Override
    public boolean isFastForwarding() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isFastForwarding());
    }

    @Override
    public boolean isHardwareError() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isHardwareError());
    }

    @Override
    public boolean isJogging() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isJogging());
    }

    @Override
    public boolean isLocal() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isLocal());
    }

    @Override
    public boolean isPlaying() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isPlaying());
    }

    @Override
    public boolean isRecording() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isRecording());
    }

    @Override
    public boolean isReverseDirection() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isReverseDirection());
    }

    @Override
    public boolean isRewinding() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isRewinding());
    }

    @Override
    public boolean isServoLock() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isServoLock());
    }

    @Override
    public boolean isServoRef() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isServoRef());
    }

    @Override
    public boolean isShuttling() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isShuttling());
    }

    @Override
    public boolean isStandingBy() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isStandingBy());
    }

    @Override
    public boolean isStill() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isStill());
    }

    @Override
    public boolean isStopped() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isStopped());
    }

    @Override
    public boolean isTapeEnd() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isTapeEnd());
    }

    @Override
    public boolean isTapeTrouble() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isTapeTrouble());
    }

    @Override
    public boolean isTso() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isTso());
    }

    @Override
    public boolean isUnthreaded() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isUnthreaded());
    }

    @Override
    public boolean isVarSpeed() {
        return this.apply(() -> ((RS422State)this.videoState.get()).isVarSpeed());
    }

    private boolean apply(Supplier<Boolean> fn) {
        boolean v;
        try {
            v = Optional.ofNullable(fn.get()).orElse(false);
        }
        catch (Exception e) {
            v = false;
        }
        return v;
    }
}

