/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.adapter;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.mbari.vcr4j.VCRErrorAdapter;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.rs422.RS422Error;
import org.mbari.vcr4j.rs422.RS422State;

public class RS422ErrorFacade<S extends RS422State, E extends RS422Error>
extends VCRErrorAdapter {
    private final AtomicReference<E> videoError = new AtomicReference();

    public RS422ErrorFacade(VideoIO<S, E> videoIO) {
        videoIO.getErrorObservable().forEach(e -> {
            this.videoError.set(e);
            this.oc.notify((Object)this, null);
        });
    }

    @Override
    public boolean isChecksumError() {
        return this.apply(() -> ((RS422Error)this.videoError.get()).isChecksumError());
    }

    @Override
    public boolean isFramingError() {
        return this.apply(() -> ((RS422Error)this.videoError.get()).isFramingError());
    }

    @Override
    public boolean isOK() {
        return this.apply(() -> ((RS422Error)this.videoError.get()).isOK());
    }

    @Override
    public boolean isOverrunError() {
        return this.apply(() -> ((RS422Error)this.videoError.get()).isOverrunError());
    }

    @Override
    public boolean isParityError() {
        return this.apply(() -> ((RS422Error)this.videoError.get()).isParityError());
    }

    @Override
    public boolean isTimeout() {
        return this.apply(() -> ((RS422Error)this.videoError.get()).isTimeout());
    }

    @Override
    public boolean isUndefinedCommand() {
        return this.apply(() -> ((RS422Error)this.videoError.get()).isUndefinedCommand());
    }

    private boolean apply(Supplier<Boolean> fn) {
        boolean v;
        try {
            v = Optional.ofNullable(fn.get()).orElse(false);
        }
        catch (Exception e) {
            v = false;
        }
        return v;
    }
}

