/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j;

import org.mbari.util.IObserver;
import org.mbari.util.ObservableSupport;
import org.mbari.vcr4j.IVCRUserbits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCRUserbitsAdapter
implements IVCRUserbits {
    private static final Logger log = LoggerFactory.getLogger(VCRUserbitsAdapter.class);
    private final ObservableSupport os = new ObservableSupport();
    private volatile byte[] userbits = new byte[]{0, 0, 0, 0};

    public void addObserver(IObserver observer) {
        this.os.add(observer);
    }

    @Override
    public byte[] getUserbits() {
        return this.userbits;
    }

    protected void notifyObservers() {
        if (log.isDebugEnabled()) {
            StringBuffer b = new StringBuffer("Notification of new Userbits: [");
            for (int i = 0; i < this.userbits.length; ++i) {
                b.append(this.userbits[i]);
                if (i >= this.userbits.length - 1) continue;
                b.append(", ");
            }
            b.append("]");
            log.debug(b.toString());
        }
        this.os.notify((Object)this, null);
    }

    public void removeAllObservers() {
        this.os.clear();
    }

    public void removeObserver(IObserver observer) {
        this.os.remove(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserbits(byte[] userbits) {
        byte[] byArray = this.userbits;
        synchronized (this.userbits) {
            this.userbits = userbits;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.notifyObservers();
            return;
        }
    }
}

