/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j;

import java.text.DecimalFormat;
import java.util.Optional;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.mbari.util.IObserver;
import org.mbari.util.ObservableSupport;
import org.mbari.vcr4j.IVCRTimecode;
import org.mbari.vcr4j.time.HMSF;
import org.mbari.vcr4j.time.Timecode;

public class VCRTimecodeAdapter
implements IVCRTimecode {
    private static final DecimalFormat f = new DecimalFormat();
    private static final Timecode TIMECODE_EMPTY = new Timecode("--:--:--:--");
    private final ObservableSupport os = new ObservableSupport();
    protected ObjectProperty<Timecode> timecodeProperty = new SimpleObjectProperty();

    public VCRTimecodeAdapter() {
        this.timecodeProperty.addListener((observable, oldValue, newValue) -> this.notifyObservers());
    }

    @Override
    public ObjectProperty<Timecode> timecodeProperty() {
        return this.timecodeProperty;
    }

    public void addObserver(IObserver observer) {
        this.os.add(observer);
    }

    private int extractTimecodeValue(Optional<Timecode> tc, Function<Timecode, Integer> fn) {
        return tc.map(fn).orElseGet(() -> 0);
    }

    @Override
    public int getFrame() {
        return this.extractTimecodeValue(Optional.ofNullable(this.timecodeProperty.get()), tc -> tc.getHMSF().map(HMSF::getFrame).orElse(0));
    }

    @Override
    public int getHour() {
        return this.extractTimecodeValue(Optional.ofNullable(this.timecodeProperty.get()), tc -> tc.getHMSF().map(HMSF::getHour).orElse(0));
    }

    @Override
    public int getMinute() {
        return this.extractTimecodeValue(Optional.ofNullable(this.timecodeProperty.get()), tc -> tc.getHMSF().map(HMSF::getMinute).orElse(0));
    }

    @Override
    public int getSecond() {
        return this.extractTimecodeValue(Optional.ofNullable(this.timecodeProperty.get()), tc -> tc.getHMSF().map(HMSF::getSecond).orElse(0));
    }

    @Override
    public Timecode getTimecode() {
        return (Timecode)Optional.ofNullable(this.timecodeProperty.get()).orElse(TIMECODE_EMPTY);
    }

    protected void notifyObservers() {
        this.os.notify((Object)this, null);
    }

    public void removeAllObservers() {
        this.os.clear();
    }

    public void removeObserver(IObserver observer) {
        this.os.remove(observer);
    }

    public String toString() {
        return ((Timecode)Optional.ofNullable(this.timecodeProperty.get()).orElse(TIMECODE_EMPTY)).toString();
    }

    static {
        f.setMaximumFractionDigits(0);
        f.setMinimumIntegerDigits(2);
        f.setMaximumIntegerDigits(2);
    }

    private class Observer
    implements IObserver {
        private Observer() {
        }

        public void update(Object obj, Object changeCode) {
            VCRTimecodeAdapter.this.notifyObservers();
        }
    }
}

