/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer.jfx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.NonDigitConsumingKeyListener;
import org.mbari.swing.SpinningDialWaitIndicator;
import org.mbari.text.IgnoreCaseToStringComparator;
import org.mbari.util.Tuple2;
import org.mbari.vcr4j.SimpleVideoError;
import org.mbari.vcr4j.javafx.JFXVideoState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.CacheClearedEvent;
import vars.CacheClearedListener;
import vars.ToolBelt;
import vars.VARSException;
import vars.annotation.AnnotationPersistenceService;
import vars.annotation.CameraDeployment;
import vars.annotation.VideoArchive;
import vars.avplayer.VideoController;
import vars.avplayer.VideoPlayerDialogUI;
import vars.avplayer.jfx.JFXVideoPlayer;
import vars.avplayer.jfx.VideoParams;
import vars.shared.ui.dialogs.StandardDialog;

public class JFXVideoPlayerDialogUI
extends StandardDialog
implements VideoPlayerDialogUI {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int RESPONSE_DELAY = 750;
    private static final Runnable DO_NOTHING_FUNCTION = () -> {};
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final ItemListener rbItemListener = new SelectedRBItemListener();
    private JPanel panel;
    private final ToolBelt toolBelt;
    private JLabel lblMovie;
    private JTextField urlTextField;
    private JButton browseButton;
    private JRadioButton openByLocationRB;
    private JLabel lblCameraPlatform;
    private JComboBox cameraPlatformComboBox;
    private JLabel lblSequenceNumber;
    private JTextField sequenceNumberTextField;
    private JRadioButton openExistingRB;
    private JLabel lblSelectName;
    private JComboBox existingNamesComboBox;
    private boolean loadExistingNames = true;
    private final Timer delayTimer;
    private final Timer updateOkayTimer;
    private JLabel selectTimeSourcelbl;
    private Runnable onOkayFunction = DO_NOTHING_FUNCTION;
    private final JFXVideoPlayer videoPlayer;

    public JFXVideoPlayerDialogUI(Window parent, ToolBelt toolBelt, JFXVideoPlayer videoPlayer) {
        super(parent);
        this.videoPlayer = videoPlayer;
        this.toolBelt = toolBelt;
        ActionListener changeItemAction = e -> this.updateVideoArchiveParameters();
        this.delayTimer = new Timer(750, changeItemAction);
        this.delayTimer.setRepeats(false);
        ActionListener updateOkayAction = e -> this.updateOkayStatus();
        this.updateOkayTimer = new Timer(750, updateOkayAction);
        this.updateOkayTimer.setRepeats(false);
        this.initialize();
        this.getRootPane().setDefaultButton(this.getOkayButton());
        this.getOkayButton().addActionListener(actionEvent -> this.callOkayFunction());
        this.pack();
        toolBelt.getPersistenceCache().addCacheClearedListener(new CacheClearedListener(){

            public void afterClear(CacheClearedEvent evt) {
                JFXVideoPlayerDialogUI.this.loadExistingNames = true;
            }

            public void beforeClear(CacheClearedEvent evt) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)JFXVideoPlayerDialogUI.this.getExistingNamesComboBox().getModel();
                model.removeAllElements();
            }
        });
        this.updateOkayStatus();
    }

    public void onOkay(Runnable fn) {
        this.onOkayFunction = fn;
    }

    public void onCancel(Runnable fn) {
    }

    private void callOkayFunction() {
        if (this.onOkayFunction != null) {
            try {
                this.onOkayFunction.run();
            }
            catch (Exception e) {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
            }
        }
    }

    protected ToolBelt getToolBelt() {
        return this.toolBelt;
    }

    protected void initialize() {
        this.setPreferredSize(new Dimension(475, 400));
        this.buttonGroup.add(this.getOpenByLocationRB());
        this.buttonGroup.add(this.getOpenExistingRB());
        this.buttonGroup.setSelected(this.getOpenByLocationRB().getModel(), true);
        this.getOkayButton().addActionListener(e -> this.setVisible(false));
        this.getCancelButton().addActionListener(e -> this.setVisible(false));
        this.getContentPane().add((Component)this.getPanel(), "Center");
        this.getOpenByLocationRB().setSelected(true);
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            GroupLayout gl_panel = new GroupLayout(this.panel);
            gl_panel.setHorizontalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addContainerGap().addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getOpenByLocationRB()).addGroup(gl_panel.createSequentialGroup().addGap(29).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getBrowseButton()).addGroup(gl_panel.createSequentialGroup().addComponent(this.getLblMovie()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getUrlTextField(), -1, 387, Short.MAX_VALUE)).addGroup(gl_panel.createSequentialGroup().addComponent(this.getLblCameraPlatform(), -2, 108, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getCameraPlatformComboBox(), 0, 314, Short.MAX_VALUE)).addGroup(gl_panel.createSequentialGroup().addComponent(this.getLblSequenceNumber(), -2, 117, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getSequenceNumberTextField(), -2, 311, -2)))).addComponent(this.getOpenExistingRB()).addGroup(gl_panel.createSequentialGroup().addGap(29).addComponent(this.getLblSelectName(), -2, 81, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getExistingNamesComboBox(), 0, 353, Short.MAX_VALUE))).addContainerGap()));
            gl_panel.setVerticalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addContainerGap().addComponent(this.getOpenByLocationRB()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblMovie()).addComponent(this.getUrlTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getBrowseButton()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblCameraPlatform()).addComponent(this.getCameraPlatformComboBox(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblSequenceNumber()).addComponent(this.getSequenceNumberTextField(), -2, -1, -2)).addGap(18).addComponent(this.getOpenExistingRB()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblSelectName()).addComponent(this.getExistingNamesComboBox(), -2, -1, -2)).addContainerGap(91, Short.MAX_VALUE)));
            this.panel.setLayout(gl_panel);
        }
        return this.panel;
    }

    private String[] listCameraPlatforms() {
        String[] cp = new String[]{""};
        try {
            AnnotationPersistenceService aps = this.toolBelt.getAnnotationPersistenceService();
            List cameraPlatforms = aps.findAllCameraPlatforms();
            cp = new String[cameraPlatforms.size()];
            cameraPlatforms.toArray(cp);
            Arrays.sort(cp, new IgnoreCaseToStringComparator());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cp;
    }

    private JLabel getLblMovie() {
        if (this.lblMovie == null) {
            this.lblMovie = new JLabel("Movie:");
        }
        return this.lblMovie;
    }

    protected JTextField getUrlTextField() {
        if (this.urlTextField == null) {
            this.urlTextField = new JTextField();
            this.urlTextField.setColumns(60);
            this.urlTextField.setToolTipText("Enter movie URL");
            this.urlTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }

                public void update() {
                    JFXVideoPlayerDialogUI.this.delayTimer.restart();
                    JFXVideoPlayerDialogUI.this.updateOkayTimer.restart();
                }
            });
            this.urlTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    JFXVideoPlayerDialogUI.this.updateVideoArchiveParameters();
                    JFXVideoPlayerDialogUI.this.updateOkayStatus();
                }
            });
        }
        return this.urlTextField;
    }

    private JButton getBrowseButton() {
        if (this.browseButton == null) {
            this.browseButton = new JButton("Browse");
            this.browseButton.setToolTipText("Browse for local file");
            this.browseButton.addActionListener(new ActionListener(){
                final JFileChooser chooser = new JFileChooser();

                @Override
                public void actionPerformed(ActionEvent e) {
                    int option = this.chooser.showOpenDialog((Component)((Object)JFXVideoPlayerDialogUI.this));
                    if (option == 0) {
                        File file = this.chooser.getSelectedFile();
                        try {
                            JFXVideoPlayerDialogUI.this.urlTextField.setText(file.toURI().toURL().toExternalForm());
                        }
                        catch (MalformedURLException e1) {
                            JFXVideoPlayerDialogUI.this.log.warn("Invalid File", (Throwable)e1);
                        }
                    }
                }
            });
        }
        return this.browseButton;
    }

    protected JRadioButton getOpenByLocationRB() {
        if (this.openByLocationRB == null) {
            this.openByLocationRB = new JRadioButton("Open by Location");
            this.openByLocationRB.addItemListener(this.rbItemListener);
        }
        return this.openByLocationRB;
    }

    private JLabel getLblCameraPlatform() {
        if (this.lblCameraPlatform == null) {
            this.lblCameraPlatform = new JLabel("Camera Platform:");
        }
        return this.lblCameraPlatform;
    }

    protected JComboBox getCameraPlatformComboBox() {
        if (this.cameraPlatformComboBox == null) {
            this.cameraPlatformComboBox = new JComboBox();
            this.cameraPlatformComboBox.setModel(new DefaultComboBoxModel<String>(this.listCameraPlatforms()));
        }
        return this.cameraPlatformComboBox;
    }

    private JLabel getLblSequenceNumber() {
        if (this.lblSequenceNumber == null) {
            this.lblSequenceNumber = new JLabel("Sequence Number:");
        }
        return this.lblSequenceNumber;
    }

    protected JTextField getSequenceNumberTextField() {
        if (this.sequenceNumberTextField == null) {
            this.sequenceNumberTextField = new JTextField();
            this.sequenceNumberTextField.setColumns(10);
            this.sequenceNumberTextField.addKeyListener((KeyListener)new NonDigitConsumingKeyListener());
            this.sequenceNumberTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }

                private void update() {
                    JFXVideoPlayerDialogUI.this.updateOkayTimer.restart();
                }
            });
        }
        return this.sequenceNumberTextField;
    }

    protected JRadioButton getOpenExistingRB() {
        if (this.openExistingRB == null) {
            this.openExistingRB = new JRadioButton("Open Existing");
            this.openExistingRB.addItemListener(this.rbItemListener);
            this.openExistingRB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (JFXVideoPlayerDialogUI.this.loadExistingNames) {
                        JComboBox comboBox = JFXVideoPlayerDialogUI.this.getExistingNamesComboBox();
                        SpinningDialWaitIndicator waitIndicator = new SpinningDialWaitIndicator((JComponent)comboBox);
                        List names = JFXVideoPlayerDialogUI.this.toolBelt.getAnnotationPersistenceService().findAllVideoArchiveNames();
                        String[] van = new String[names.size()];
                        names.toArray(van);
                        comboBox.setModel(new DefaultComboBoxModel<String>(van));
                        waitIndicator.dispose();
                        JFXVideoPlayerDialogUI.this.loadExistingNames = false;
                    }
                }
            });
        }
        return this.openExistingRB;
    }

    private JLabel getLblSelectName() {
        if (this.lblSelectName == null) {
            this.lblSelectName = new JLabel("Select Name:");
        }
        return this.lblSelectName;
    }

    protected JComboBox getExistingNamesComboBox() {
        if (this.existingNamesComboBox == null) {
            this.existingNamesComboBox = new JComboBox();
            this.existingNamesComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        JFXVideoPlayerDialogUI.this.updateOkayStatus();
                    }
                }
            });
        }
        return this.existingNamesComboBox;
    }

    private void updateVideoArchiveParameters() {
        Optional<VideoArchive> videoArchiveOpt = this.videoPlayer.findByLocation(this.getUrlTextField().getText(), this.toolBelt.getAnnotationDAOFactory());
        if (videoArchiveOpt.isPresent()) {
            VideoArchive videoArchive = videoArchiveOpt.get();
            this.getSequenceNumberTextField().setEnabled(false);
            CameraDeployment cameraDeployment = (CameraDeployment)videoArchive.getVideoArchiveSet().getCameraDeployments().iterator().next();
            this.getSequenceNumberTextField().setText(cameraDeployment.getSequenceNumber() + "");
            this.getCameraPlatformComboBox().setEnabled(false);
            this.getCameraPlatformComboBox().setSelectedItem(videoArchive.getVideoArchiveSet().getPlatformName());
            this.updateOkayStatus();
        } else {
            this.getSequenceNumberTextField().setEnabled(true);
            this.getSequenceNumberTextField().setText("");
            this.getCameraPlatformComboBox().setEnabled(true);
            this.updateOkayStatus();
        }
    }

    private void updateOkayStatus() {
        boolean enable = false;
        if (this.getOpenExistingRB().isSelected()) {
            enable = this.getExistingNamesComboBox().getSelectedItem() != null;
        } else {
            String sequenceNumber = this.getSequenceNumberTextField().getText();
            String platform = (String)this.getCameraPlatformComboBox().getSelectedItem();
            enable = sequenceNumber != null && sequenceNumber.length() > 0 && platform != null;
        }
        this.getOkayButton().setEnabled(enable);
    }

    public Tuple2<VideoArchive, VideoController<JFXVideoState, SimpleVideoError>> openVideoArchive() {
        VideoParams videoParams;
        if (this.getOpenExistingRB().isSelected()) {
            String videoArchiveName = (String)this.getExistingNamesComboBox().getSelectedItem();
            videoParams = new VideoParams(videoArchiveName, null, null);
        } else {
            String platformName = (String)this.getCameraPlatformComboBox().getSelectedItem();
            if (platformName != null && platformName.length() == 0) {
                platformName = null;
            }
            Integer sequenceNumber = null;
            try {
                sequenceNumber = Integer.parseInt(this.getSequenceNumberTextField().getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            String movieLocation = this.getUrlTextField().getText();
            if (movieLocation == null || movieLocation.trim().length() == 0) {
                throw new VARSException("Unless you provide a movie location, VARS can't open the video file.");
            }
            videoParams = new VideoParams(movieLocation, platformName, sequenceNumber);
        }
        Tuple2<VideoArchive, VideoController<JFXVideoState, SimpleVideoError>> vids = null;
        try {
            vids = this.videoPlayer.openVideoArchive(this.toolBelt, videoParams).get(4L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.log.warn("Failed to open video player", (Throwable)e);
        }
        return vids;
    }

    private JLabel getSelectTimeSourcelbl() {
        if (this.selectTimeSourcelbl == null) {
            this.selectTimeSourcelbl = new JLabel("Select Time Source:");
        }
        return this.selectTimeSourcelbl;
    }

    class SelectedRBItemListener
    implements ItemListener {
        SelectedRBItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                JRadioButton radioButton = (JRadioButton)e.getItemSelectable();
                if (radioButton.equals(JFXVideoPlayerDialogUI.this.getOpenByLocationRB())) {
                    JFXVideoPlayerDialogUI.this.getUrlTextField().setEnabled(true);
                    JFXVideoPlayerDialogUI.this.getBrowseButton().setEnabled(true);
                    JFXVideoPlayerDialogUI.this.getSequenceNumberTextField().setEnabled(false);
                    JFXVideoPlayerDialogUI.this.getCameraPlatformComboBox().setEnabled(false);
                    JFXVideoPlayerDialogUI.this.getExistingNamesComboBox().setEnabled(false);
                } else {
                    JFXVideoPlayerDialogUI.this.getUrlTextField().setEnabled(false);
                    JFXVideoPlayerDialogUI.this.getBrowseButton().setEnabled(false);
                    JFXVideoPlayerDialogUI.this.getSequenceNumberTextField().setEnabled(false);
                    JFXVideoPlayerDialogUI.this.getCameraPlatformComboBox().setEnabled(false);
                    JFXVideoPlayerDialogUI.this.getExistingNamesComboBox().setEnabled(true);
                }
            }
        }
    }
}

