/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer.jfx;

import java.awt.Frame;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javax.swing.SwingUtilities;
import org.mbari.util.Tuple2;
import org.mbari.vcr4j.SimpleVideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.decorators.SchedulerVideoIO;
import org.mbari.vcr4j.decorators.StatusDecorator;
import org.mbari.vcr4j.decorators.VCRSyncDecorator;
import org.mbari.vcr4j.javafx.JFXVideoIO;
import org.mbari.vcr4j.javafx.JFXVideoState;
import org.mbari.vcr4j.javafx.decorators.FauxTimecodeDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ToolBelt;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.avplayer.ImageCaptureService;
import vars.avplayer.VideoController;
import vars.avplayer.VideoPlayer;
import vars.avplayer.VideoPlayerDialogUI;
import vars.avplayer.jfx.JFXImageCaptureService;
import vars.avplayer.jfx.JFXMovieJFrame;
import vars.avplayer.jfx.JFXMovieJFrameController;
import vars.avplayer.jfx.JFXVideoPlayerDialogUI;
import vars.avplayer.jfx.VideoParams;
import vars.avplayer.rx.SetVideoArchiveMsg;
import vars.avplayer.rx.SetVideoControllerMsg;
import vars.shared.rx.RXEventBus;
import vars.shared.ui.GlobalStateLookup;

public class JFXVideoPlayer
implements VideoPlayer<JFXVideoState, SimpleVideoError> {
    private static final List<String> ACCEPTABLE_MIMETYPES = Arrays.asList("video/mp4");
    private volatile JFXMovieJFrame movieFrame = new JFXMovieJFrame();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile JFXMovieJFrameController controller;
    private VideoPlayerDialogUI dialogUI;

    public boolean canPlay(String mimeType) {
        return ACCEPTABLE_MIMETYPES.stream().filter(s -> s.equalsIgnoreCase(mimeType)).count() > 0L;
    }

    public CompletableFuture<VideoController<JFXVideoState, SimpleVideoError>> createVideoController(String movieLocation) {
        CompletableFuture<VideoController<JFXVideoState, SimpleVideoError>> cf = new CompletableFuture<VideoController<JFXVideoState, SimpleVideoError>>();
        try {
            this.movieFrame.setVisible(false);
            this.movieFrame.setMediaLocation(movieLocation, c -> {
                this.controller = c;
                MediaPlayer mediaPlayer = c.getMediaView().getMediaPlayer();
                Media media = mediaPlayer.getMedia();
                JFXVideoIO videoIO = new JFXVideoIO(mediaPlayer);
                new StatusDecorator((VideoIO)videoIO);
                new VCRSyncDecorator((VideoIO)videoIO);
                new FauxTimecodeDecorator(videoIO);
                SchedulerVideoIO io = new SchedulerVideoIO((VideoIO)videoIO, (Executor)Executors.newCachedThreadPool());
                cf.complete(new VideoController((ImageCaptureService)new JFXImageCaptureService(this.controller), (VideoIO)io));
                SwingUtilities.invokeLater(() -> {
                    this.movieFrame.setSize(media.getWidth(), media.getHeight());
                    this.movieFrame.setVisible(true);
                });
            });
        }
        catch (Exception e) {
            this.log.error("Failed to create JFXMovieJFrame", (Throwable)e);
            cf.completeExceptionally(e);
        }
        return cf;
    }

    public VideoPlayerDialogUI getConnectionDialog(ToolBelt toolBelt, RXEventBus eventBus) {
        if (this.dialogUI == null) {
            Frame window = GlobalStateLookup.getSelectedFrame();
            this.dialogUI = new JFXVideoPlayerDialogUI(window, toolBelt, this);
            this.dialogUI.onOkay(() -> {
                this.dialogUI.setVisible(false);
                Tuple2<VideoArchive, VideoController<JFXVideoState, SimpleVideoError>> data = ((JFXVideoPlayerDialogUI)this.dialogUI).openVideoArchive();
                VideoArchive videoArchive = (VideoArchive)data.getA();
                VideoController videoController = (VideoController)data.getB();
                eventBus.send((Object)new SetVideoArchiveMsg(videoArchive));
                eventBus.send((Object)new SetVideoControllerMsg(videoController));
            });
        }
        return this.dialogUI;
    }

    public CompletableFuture<Tuple2<VideoArchive, VideoController<JFXVideoState, SimpleVideoError>>> openVideoArchive(ToolBelt toolBelt, Object ... args) {
        String movieLocation = (String)args[0];
        String platformName = (String)args[1];
        Integer sequenceNumber = (Integer)args[2];
        return this.openVideoArchive(toolBelt, movieLocation, platformName, sequenceNumber);
    }

    protected CompletableFuture<Tuple2<VideoArchive, VideoController<JFXVideoState, SimpleVideoError>>> openVideoArchive(ToolBelt toolBelt, String movieLocation, String platformName, Integer sequenceNumber) {
        return this.openVideoArchive(toolBelt, new VideoParams(movieLocation, platformName, sequenceNumber));
    }

    protected CompletableFuture<Tuple2<VideoArchive, VideoController<JFXVideoState, SimpleVideoError>>> openVideoArchive(ToolBelt toolBelt, VideoParams videoParams) {
        VideoArchive videoArchive = this.getOrCreateVideoArchive(videoParams, toolBelt.getAnnotationDAOFactory());
        return this.createVideoController(videoArchive.getName()).thenCompose(c -> CompletableFuture.supplyAsync(() -> new Tuple2((Object)videoArchive, c)));
    }

    public Optional<VideoArchive> findByLocation(String location, AnnotationDAOFactory daoFactory) {
        VideoArchiveDAO dao = daoFactory.newVideoArchiveDAO();
        dao.startTransaction();
        VideoArchive videoArchive = dao.findByName(location);
        dao.endTransaction();
        return Optional.ofNullable(videoArchive);
    }

    private VideoArchive createVideoArchive(VideoParams videoParams, AnnotationDAOFactory daoFactory) {
        VideoArchive videoArchive = null;
        if (videoParams.getPlatformName().isPresent() && videoParams.getSequenceNumber().isPresent()) {
            String location = videoParams.getMovieLocation();
            int sequenceNumber = videoParams.getSequenceNumber().get();
            String platform = videoParams.getPlatformName().get();
            VideoArchiveDAO dao = daoFactory.newVideoArchiveDAO();
            dao.startTransaction();
            videoArchive = dao.findOrCreateByParameters(platform, sequenceNumber, location);
            dao.endTransaction();
        }
        return videoArchive;
    }

    protected VideoArchive getOrCreateVideoArchive(VideoParams videoParams, AnnotationDAOFactory daoFactory) {
        return this.findByLocation(videoParams.getMovieLocation(), daoFactory).orElseGet(() -> this.createVideoArchive(videoParams, daoFactory));
    }

    public String getName() {
        return "MP4 using Java";
    }
}

