/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer.jfx;

import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Button;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.AnchorPane;
import javafx.scene.media.Media;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.util.Duration;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.image.ImageUtilities;
import org.mbari.vcr4j.time.Timecode;
import vars.avplayer.jfx.JFXUtilities;

public class JFXMovieJFrameController
implements Initializable {
    public static final Double DEFAULT_FRAME_RATE = 100.0;
    @FXML
    private AnchorPane anchorPane;
    @FXML
    private TextField maxTimecodeTextField;
    @FXML
    private Slider scrubber;
    @FXML
    private MediaView mediaView;
    @FXML
    private TextField timecodeTextField;
    @FXML
    private Button playButton;
    private MediaPlayer mediaPlayer;
    private BooleanProperty readyProperty = new SimpleBooleanProperty(false);

    public void initialize(URL location, ResourceBundle resources) {
    }

    public AnchorPane getAnchorPane() {
        return this.anchorPane;
    }

    public MediaView getMediaView() {
        return this.mediaView;
    }

    public MediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public void setMediaLocation(String mediaLocation, Consumer<JFXMovieJFrameController> onReadyRunnable) {
        Preconditions.checkNotNull((Object)mediaLocation, (Object)"The medialocation can not be null");
        this.scrubber.setDisable(true);
        Media media = null;
        try {
            media = new Media(mediaLocation);
        }
        catch (MediaException e2) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("Media type is not supported: " + mediaLocation));
        }
        this.mediaPlayer = new MediaPlayer(media);
        this.mediaView.setMediaPlayer(this.mediaPlayer);
        this.mediaPlayer.currentTimeProperty().addListener(observable -> this.updateValues());
        this.mediaPlayer.setOnPlaying(() -> this.playButton.setText("||"));
        this.mediaPlayer.setOnPaused(() -> this.playButton.setText(">"));
        this.mediaPlayer.setOnReady(() -> {
            Media m = this.mediaPlayer.getMedia();
            Timecode timecode = JFXUtilities.jfxDurationToTimecode(m.getDuration());
            SwingUtilities.invokeLater(() -> this.maxTimecodeTextField.setText(timecode.toString()));
            this.updateValues();
            onReadyRunnable.accept(this);
            this.readyProperty.setValue(Boolean.valueOf(true));
        });
        this.mediaPlayer.setOnEndOfMedia(() -> this.playButton.setText(">"));
        this.playButton.setOnAction(e -> {
            MediaPlayer.Status status = this.mediaPlayer.getStatus();
            System.out.println(status);
            if (status == MediaPlayer.Status.UNKNOWN || status == MediaPlayer.Status.HALTED) {
                return;
            }
            if (status == MediaPlayer.Status.PLAYING) {
                this.mediaPlayer.pause();
            } else if (status == MediaPlayer.Status.PAUSED || status == MediaPlayer.Status.READY || status == MediaPlayer.Status.STOPPED) {
                this.mediaPlayer.play();
            }
        });
        this.scrubber.valueProperty().addListener(observable -> {
            if (this.scrubber.isValueChanging()) {
                Media m = this.mediaPlayer.getMedia();
                this.mediaPlayer.seek(m.getDuration().multiply(this.scrubber.getValue() / 100.0));
            } else {
                this.updateValues();
            }
        });
    }

    public boolean isReady() {
        return this.readyProperty.get();
    }

    public BooleanProperty readyProperty() {
        return this.readyProperty;
    }

    public void dispose() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
        }
    }

    public BufferedImage frameCapture(File target) throws IOException, InterruptedException, TimeoutException, ExecutionException {
        BufferedImage bufferedImage = null;
        if (this.mediaView != null) {
            Platform.runLater(() -> {
                WritableImage image = this.mediaView.snapshot(new SnapshotParameters(), null);
                System.out.println("Saving image to " + target.getAbsolutePath());
                try {
                    ImageUtilities.saveImage((RenderedImage)SwingFXUtils.fromFXImage((Image)image, null), (File)target);
                }
                catch (IOException e) {
                    System.out.println("Failed to write " + target.getAbsolutePath());
                }
            });
            java.time.Duration timeout = java.time.Duration.ofSeconds(8L);
            CompletableFuture imageFuture = vars.shared.ui.ImageUtilities.readImageAsync((File)target, (java.time.Duration)timeout);
            bufferedImage = (BufferedImage)imageFuture.get(timeout.getSeconds(), TimeUnit.SECONDS);
            if (bufferedImage == null) {
                // empty if block
            }
        }
        return bufferedImage;
    }

    protected void updateValues() {
        if (this.timecodeTextField != null && this.scrubber != null && this.mediaPlayer != null) {
            Platform.runLater(() -> {
                Duration currentTime = this.mediaPlayer.getCurrentTime();
                Duration totalTime = this.mediaPlayer.getMedia().getDuration();
                Timecode timecode = JFXUtilities.jfxDurationToTimecode(currentTime);
                this.timecodeTextField.setText(timecode.toString());
                this.scrubber.setDisable(totalTime.isUnknown());
                if (!this.scrubber.isDisabled() && totalTime.greaterThan(Duration.ZERO) && !this.scrubber.isValueChanging()) {
                    this.scrubber.setValue(currentTime.divide(totalTime.toMillis()).toMillis() * 100.0);
                }
            });
        }
    }
}

