/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer.jfx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.media.MediaView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.BuilderFactory;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.avplayer.jfx.JFXMovieJFrameController;

public class JFXMovieJFrame
extends JFrame {
    private final JFXPanel panel = new JFXPanel();
    private volatile JFXMovieJFrameController controller;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public JFXMovieJFrame() throws HeadlessException {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panel);
        this.setSize(480, 320);
        this.setDefaultCloseOperation(1);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (JFXMovieJFrame.this.controller != null) {
                    MediaView mediaView = JFXMovieJFrame.this.controller.getMediaView();
                    mediaView.setFitHeight((double)JFXMovieJFrame.this.getHeight());
                    mediaView.setFitWidth((double)JFXMovieJFrame.this.getWidth());
                }
            }
        });
    }

    public CompletableFuture<JFXMovieJFrameController> setMediaLocation(String location, Consumer<JFXMovieJFrameController> onReadyRunnable) {
        CompletableFuture<JFXMovieJFrameController> future = new CompletableFuture<JFXMovieJFrameController>();
        Platform.runLater(() -> {
            try {
                this.disposeJFXNodes();
                future.complete(this.initJFXNodes(location, onReadyRunnable));
            }
            catch (IOException e) {
                this.log.error("Failed to initialize JavaFX scene", (Throwable)e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private void disposeJFXNodes() {
        if (this.controller != null) {
            this.panel.setScene(new Scene((Parent)new Pane(), (Paint)Color.BLACK));
            this.controller = null;
        }
    }

    private JFXMovieJFrameController initJFXNodes(String location, Consumer<JFXMovieJFrameController> onReadyRunnable) throws IOException {
        URL controllerLocation = this.getClass().getResource("/fxml/JFXMovieJFrame.fxml");
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(controllerLocation);
        loader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
        Parent root = (Parent)loader.load(controllerLocation.openStream());
        this.controller = (JFXMovieJFrameController)loader.getController();
        this.controller.setMediaLocation(location, onReadyRunnable);
        Scene scene = new Scene(root);
        scene.getStylesheets().add((Object)"/styles/JFXMovieFrame.css");
        this.panel.setScene(scene);
        MediaView mediaView = this.controller.getMediaView();
        mediaView.setFitWidth((double)this.getWidth());
        mediaView.setFitHeight((double)this.getHeight());
        return this.controller;
    }
}

