/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer.jfx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JFXMovieApp {
    private static final String MEDIA_URL = "http://download.oracle.com/otndocs/products/javafx/oow2010-2.flv";
    JFrame frame;
    JPanel panel;
    JFXPanel mediaPanel;
    MediaView mediaView;
    JFXPanel controlPanel;
    private final String movie;

    public static void main(String[] args) {
        String movie = MEDIA_URL;
        if (args.length > 0) {
            movie = args[0];
        }
        JFXMovieApp app = new JFXMovieApp(movie);
        JFrame frame = app.getFrame();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public JFXMovieApp(String movie) {
        this.movie = movie;
        this.initialize();
    }

    public JFXMovieApp() {
        this(MEDIA_URL);
    }

    protected void initialize() {
        final JFrame myFrame = this.getFrame();
        Platform.runLater(() -> {
            Media media = new Media(this.movie);
            MediaPlayer mediaPlayer = new MediaPlayer(media);
            mediaPlayer.setAutoPlay(true);
            this.getMediaView().setMediaPlayer(mediaPlayer);
            mediaPlayer.setOnReady(() -> myFrame.setSize(media.getWidth(), media.getHeight()));
        });
        myFrame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Platform.runLater(() -> {
                    JFXMovieApp.this.getMediaView().setFitWidth((double)myFrame.getWidth());
                    JFXMovieApp.this.getMediaView().setFitHeight((double)myFrame.getHeight());
                });
            }
        });
    }

    public JFrame getFrame() {
        if (this.frame == null) {
            this.frame = new JFrame();
            this.frame.add(this.getPanel());
        }
        return this.frame;
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.panel.add((Component)this.getMediaPanel(), "Center");
            this.panel.add((Component)this.getControlPanel(), "South");
            Platform.runLater(this::createScenes);
        }
        return this.panel;
    }

    public JFXPanel getMediaPanel() {
        if (this.mediaPanel == null) {
            this.mediaPanel = new JFXPanel();
        }
        return this.mediaPanel;
    }

    public MediaView getMediaView() {
        if (this.mediaView == null) {
            this.mediaView = new MediaView();
        }
        return this.mediaView;
    }

    public void createScenes() {
        this.getMediaPanel().setScene(new Scene((Parent)new Pane(new Node[]{this.getMediaView()})));
    }

    public JFXPanel getControlPanel() {
        if (this.controlPanel == null) {
            this.controlPanel = new JFXPanel();
        }
        return this.controlPanel;
    }
}

