/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer.jfx;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Optional;
import vars.avplayer.ImageCaptureException;
import vars.avplayer.ImageCaptureService;
import vars.avplayer.jfx.JFXMovieJFrameController;

public class JFXImageCaptureService
implements ImageCaptureService {
    private final JFXMovieJFrameController controller;

    public JFXImageCaptureService(JFXMovieJFrameController controller) {
        this.controller = controller;
    }

    public Optional<Image> capture(File file) throws ImageCaptureException {
        BufferedImage image = null;
        if (this.controller != null) {
            try {
                image = this.controller.frameCapture(file);
            }
            catch (Exception e) {
                throw new ImageCaptureException("Failed to capture image and write it to " + file.getAbsolutePath(), (Throwable)e);
            }
        }
        return Optional.ofNullable(image);
    }

    public void dispose() {
    }

    public void showSettingsDialog() {
    }
}

