/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui.sdkfx;

import com.google.common.base.Preconditions;
import com.guigarage.sdk.util.Media;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.image.Image;
import vars.LinkUtilities;
import vars.knowledgebase.Concept;
import vars.queryfx.StateLookup;
import vars.queryfx.beans.ResolvedConceptSelection;

public class ConceptMedia
implements Media {
    private final ResolvedConceptSelection conceptSelection;
    private Concept concept;
    private StringProperty title = new SimpleStringProperty();
    private StringProperty description = new SimpleStringProperty();
    private ObjectProperty<Image> image = new SimpleObjectProperty();

    public ConceptMedia(ResolvedConceptSelection conceptSelection) {
        Preconditions.checkArgument((conceptSelection != null ? 1 : 0) != 0, (Object)"Concept arg can not be null");
        this.conceptSelection = conceptSelection;
        this.init();
    }

    private void init() {
        String titleString = this.conceptSelection.getConceptName();
        if (!LinkUtilities.formatAsString(this.conceptSelection.getLink()).equals(LinkUtilities.formatAsString(StateLookup.WILD_CARD_LINK))) {
            titleString = titleString + " | " + LinkUtilities.formatAsString(this.conceptSelection.getLink());
        }
        this.title.set((Object)titleString);
        String desc = this.conceptSelection.getConcepts().stream().filter(s -> !s.equals(this.conceptSelection.getConceptName())).collect(Collectors.joining(", "));
        this.description.set((Object)desc);
        this.image.set((Object)this.conceptSelection.getImage());
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public ObjectProperty<Image> imageProperty() {
        return this.image;
    }

    public ResolvedConceptSelection getConceptSelection() {
        return this.conceptSelection;
    }
}

