/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui.sdkfx;

import com.guigarage.sdk.action.Action;
import com.guigarage.sdk.container.WorkbenchView;
import com.guigarage.sdk.footer.ActionFooter;
import com.guigarage.sdk.form.EditorFormRow;
import com.guigarage.sdk.form.FormLayout;
import com.guigarage.sdk.util.FontBasedIcon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ILink;
import vars.LinkBean;
import vars.LinkUtilities;
import vars.queryfx.AsyncQueryService;
import vars.queryfx.StateLookup;
import vars.queryfx.beans.ConceptSelection;
import vars.queryfx.rx.messages.NewConceptSelectionMsg;
import vars.queryfx.rx.messages.ShowBasicSearchWorkbenchMsg;
import vars.queryfx.ui.AppIcons;
import vars.shared.javafx.scene.control.AutoCompleteComboBoxListener;
import vars.shared.rx.RXEventBus;
import vars.shared.rx.messages.FatalExceptionMsg;

public class ConceptConstraintsWorkbench
extends WorkbenchView {
    private FormLayout formLayout = new FormLayout();
    private EditorFormRow<ComboBox<String>> conceptRow;
    private EditorFormRow<CheckBox> extendToParentRow = new EditorFormRow("parent", (Node)new CheckBox());
    private EditorFormRow<CheckBox> extendToSiblingsRow = new EditorFormRow("siblings", (Node)new CheckBox());
    private EditorFormRow<CheckBox> extendToChildrenRow = new EditorFormRow("children", (Node)new CheckBox());
    private EditorFormRow<CheckBox> extendToDescendantsRow = new EditorFormRow("descendants", (Node)new CheckBox());
    private EditorFormRow<TextField> associationSearchRow;
    private EditorFormRow<ComboBox<ILink>> associationSelectionRow;
    private ObservableList<ILink> linksForConceptSelection = FXCollections.observableArrayList();
    private FilteredList<ILink> filteredLinks = new FilteredList(this.linksForConceptSelection);
    private EditorFormRow<TextField> linkNameRow = new EditorFormRow("link", (Node)new TextField());
    private EditorFormRow<ComboBox<String>> toConceptRow = new EditorFormRow("to", (Node)new ComboBox());
    private EditorFormRow<TextField> linkValueRow = new EditorFormRow("value", (Node)new TextField());
    private final RXEventBus eventBus;
    private final Executor executor;
    private final AsyncQueryService queryService;
    private volatile CompletableFuture<List<ILink>> runningFuture;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Inject
    public ConceptConstraintsWorkbench(AsyncQueryService queryService, Executor executor, RXEventBus eventBus) {
        this.queryService = queryService;
        this.executor = executor;
        this.eventBus = eventBus;
        this.linksForConceptSelection.add((Object)StateLookup.WILD_CARD_LINK);
        this.formLayout.addHeader("", "Search by concept");
        this.formLayout.add(this.getConceptRow());
        this.formLayout.addHeader("", "extend search to the concepts");
        this.formLayout.add(this.extendToParentRow);
        this.formLayout.add(this.extendToSiblingsRow);
        this.formLayout.add(this.extendToChildrenRow);
        this.formLayout.add(this.extendToDescendantsRow);
        this.formLayout.addSeperator();
        this.formLayout.addHeader("", "Search by association");
        this.formLayout.add(this.getAssociationSearchRow());
        this.formLayout.add(this.getAssociationSelectionRow());
        this.formLayout.addHeader("", "modify association");
        this.formLayout.add(this.linkNameRow);
        this.formLayout.add(this.toConceptRow);
        this.formLayout.add(this.linkValueRow);
        ActionFooter footer = new ActionFooter();
        footer.addAction(new Action((FontBasedIcon)AppIcons.PLUS, "Apply", () -> {
            ConceptSelection conceptSelection = this.getConceptSelection();
            eventBus.send((Object)new NewConceptSelectionMsg(conceptSelection));
            eventBus.send((Object)new ShowBasicSearchWorkbenchMsg());
        }));
        footer.addAction(new Action((FontBasedIcon)AppIcons.CANCEL, "Cancel", () -> eventBus.send((Object)new ShowBasicSearchWorkbenchMsg())));
        this.setFooterNode((Node)footer);
        ChangeListener cl = (ov, oldVal, newVal) -> this.setSelectedConceptName(this.getConceptSelection());
        ((CheckBox)this.extendToParentRow.getEditor()).selectedProperty().addListener(cl);
        ((CheckBox)this.extendToSiblingsRow.getEditor()).selectedProperty().addListener(cl);
        ((CheckBox)this.extendToChildrenRow.getEditor()).selectedProperty().addListener(cl);
        ((CheckBox)this.extendToDescendantsRow.getEditor()).selectedProperty().addListener(cl);
        new AutoCompleteComboBoxListener((ComboBox)this.toConceptRow.getEditor());
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)this.formLayout);
        scrollPane.setFitToWidth(true);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.setCenterNode((Node)scrollPane);
        ((ComboBox)this.getConceptRow().getEditor()).getSelectionModel().selectFirst();
    }

    private EditorFormRow<ComboBox<String>> getConceptRow() {
        if (this.conceptRow == null) {
            ComboBox conceptComboBox = new ComboBox();
            ((CompletableFuture)this.queryService.findAllConceptNamesAsStrings().handle((names, ex) -> {
                if (names != null) {
                    return names;
                }
                this.eventBus.send((Object)new FatalExceptionMsg("Failed to look up concepts from database", ex));
                ArrayList<String> ls = new ArrayList<String>();
                ls.add("*");
                return ls;
            })).thenAccept(names -> Platform.runLater(() -> {
                conceptComboBox.setEditable(false);
                conceptComboBox.setPromptText("Loading ...");
                ObservableList obs = FXCollections.observableArrayList((Collection)names);
                obs.add(0, (Object)"*");
                conceptComboBox.setItems(obs);
                conceptComboBox.setPromptText("Enter search term (* is wildcard)");
                conceptComboBox.getSelectionModel().select(0);
                conceptComboBox.setEditable(true);
                conceptComboBox.getSelectionModel().selectedItemProperty().addListener((ov, oldVal, newVal) -> this.setSelectedConceptName(this.getConceptSelection((String)newVal)));
                new AutoCompleteComboBoxListener(conceptComboBox);
            }));
            this.conceptRow = new EditorFormRow("named", (Node)conceptComboBox);
        }
        return this.conceptRow;
    }

    private EditorFormRow<TextField> getAssociationSearchRow() {
        if (this.associationSearchRow == null) {
            TextField textField = new TextField();
            textField.setPromptText("Filter associations ...");
            textField.setOnKeyReleased(event -> {
                String text = textField.getText();
                ComboBox comboBox = (ComboBox)this.getAssociationSelectionRow().getEditor();
                if (event.getCode() == KeyCode.DOWN) {
                    comboBox.show();
                } else {
                    if (event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.LEFT || event.isControlDown() || event.getCode() == KeyCode.HOME || event.getCode() == KeyCode.END || event.getCode() == KeyCode.TAB || event.getCode() == KeyCode.UP) {
                        return;
                    }
                    if (event.getCode() == KeyCode.ENTER) {
                        comboBox.hide();
                    } else {
                        comboBox.hide();
                        if (text != null && !text.isEmpty()) {
                            String upperCaseText = text.toUpperCase();
                            this.filteredLinks.setPredicate(link -> link.getLinkName().toUpperCase().contains(upperCaseText) || link.getLinkValue().toUpperCase().contains(upperCaseText));
                        } else {
                            this.filteredLinks.setPredicate(link -> true);
                        }
                        if (!this.filteredLinks.isEmpty() && !comboBox.isShowing()) {
                            comboBox.show();
                        }
                    }
                }
            });
            this.associationSearchRow = new EditorFormRow("filter by", (Node)textField);
        }
        return this.associationSearchRow;
    }

    private EditorFormRow<ComboBox<ILink>> getAssociationSelectionRow() {
        if (this.associationSelectionRow == null) {
            ComboBox comboBox = new ComboBox(this.filteredLinks);
            comboBox.setCellFactory(listView -> new ListCell<ILink>(){

                protected void updateItem(ILink item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (item != null) {
                        this.setText(LinkUtilities.formatAsString(item));
                    }
                }
            });
            comboBox.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
                ((TextField)this.linkNameRow.getEditor()).setText(newVal.getLinkName());
                ((TextField)this.linkValueRow.getEditor()).setText(newVal.getLinkValue());
                ComboBox cb = (ComboBox)this.toConceptRow.getEditor();
                cb.setDisable(true);
                cb.getItems().clear();
                this.queryService.findDescendantNamesAsStrings(newVal.getToConcept()).thenAccept(list -> this.runOnFXThread(() -> {
                    ObservableList items = cb.getItems();
                    items.add((Object)"*");
                    if (list.isEmpty()) {
                        items.add((Object)newVal.getToConcept());
                    }
                    items.addAll((Collection)list);
                    cb.getSelectionModel().select((Object)newVal.getToConcept());
                    cb.setDisable(false);
                }));
            });
            this.associationSelectionRow = new EditorFormRow("using", (Node)comboBox);
        }
        return this.associationSelectionRow;
    }

    private void setSelectedConceptName(ConceptSelection selection) {
        if (selection.getConceptName() == null) {
            return;
        }
        Runnable resetForm = () -> {
            this.linksForConceptSelection.clear();
            this.filteredLinks.setPredicate(link -> true);
            ((TextField)this.linkNameRow.getEditor()).setText("");
            ((ComboBox)this.toConceptRow.getEditor()).getItems().clear();
            ((TextField)this.linkValueRow.getEditor()).setText("");
            ((TextField)this.getAssociationSearchRow().getEditor()).setText("");
            EditorFormRow<ComboBox<ILink>> row = this.getAssociationSelectionRow();
            ComboBox editor = (ComboBox)row.getEditor();
            editor.hide();
            editor.setDisable(true);
            editor.getEditor().setText("");
            editor.setPromptText("Loading ...");
        };
        this.runOnFXThread(resetForm);
        if (this.runningFuture != null && !this.runningFuture.isDone()) {
            this.runningFuture.cancel(true);
        }
        this.runningFuture = selection.getConceptName().equals("*") ? this.queryService.findAllLinks() : this.queryService.findConceptNamesAsStrings(selection.getConceptName(), selection.isExtendToChildren(), selection.isExtendToSiblings(), selection.isExtendToChildren(), selection.isExtendToDescendants()).thenCompose(this.queryService::findLinksByConceptNames);
        this.runningFuture.thenAccept(links -> this.runOnFXThread(() -> {
            this.linksForConceptSelection.add((Object)StateLookup.WILD_CARD_LINK);
            this.linksForConceptSelection.addAll((Collection)links);
            EditorFormRow<ComboBox<ILink>> row = this.getAssociationSelectionRow();
            ComboBox editor = (ComboBox)row.getEditor();
            editor.setPromptText("");
            editor.setDisable(false);
        }));
    }

    public ConceptSelection getConceptSelection() {
        return this.getConceptSelection((String)((ComboBox)this.conceptRow.getEditor()).getSelectionModel().getSelectedItem());
    }

    private ConceptSelection getConceptSelection(String name) {
        String linkNameP = ((TextField)this.linkNameRow.getEditor()).getText();
        ObservableList toConceptP = ((ComboBox)this.toConceptRow.getEditor()).getItems();
        String linkValueP = ((TextField)this.linkValueRow.getEditor()).getText();
        String linkName = linkNameP == null || linkNameP.isEmpty() ? "*" : linkNameP;
        String toConcept = toConceptP.isEmpty() ? "*" : (String)toConceptP.get(0);
        String linkValue = linkValueP == null || linkValueP.isEmpty() ? "*" : linkValueP;
        LinkBean link = new LinkBean(linkName, toConcept, linkValue);
        return new ConceptSelection(name, link, ((CheckBox)this.extendToParentRow.getEditor()).isSelected(), ((CheckBox)this.extendToSiblingsRow.getEditor()).isSelected(), ((CheckBox)this.extendToChildrenRow.getEditor()).isSelected(), ((CheckBox)this.extendToDescendantsRow.getEditor()).isSelected());
    }

    public FormLayout getFormLayout() {
        return this.formLayout;
    }

    private void runOnFXThread(Runnable r) {
        if (Platform.isFxApplicationThread()) {
            r.run();
        } else {
            Platform.runLater((Runnable)r);
        }
    }
}

