/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui.sdkfx;

import com.guigarage.sdk.container.WorkbenchView;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.queryfx.AsyncQueryService;
import vars.queryfx.StateLookup;
import vars.queryfx.ui.AbstractValuePanel;
import vars.queryfx.ui.ValuePanelFactory;

public class AdvancedSearchWorkbenchA
extends WorkbenchView {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ObservableList<AbstractValuePanel> valuePanels = FXCollections.observableArrayList();
    private final AsyncQueryService queryService;
    VBox root = new VBox();

    public AdvancedSearchWorkbenchA(AsyncQueryService queryService) {
        this.queryService = queryService;
        this.initialize();
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)this.root);
        scrollPane.setFitToWidth(true);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.setCenterNode((Node)scrollPane);
    }

    public void initialize() {
        this.queryService.getAnnotationViewMetadata().thenAccept(metadata -> Platform.runLater(() -> {
            ValuePanelFactory factory = new ValuePanelFactory(this.queryService);
            for (Map.Entry entry : metadata.entrySet()) {
                String columnName = (String)entry.getKey();
                if (columnName.toUpperCase().contains("ID_FK")) continue;
                AbstractValuePanel valuePanel = null;
                try {
                    valuePanel = factory.getValuePanel((String)entry.getKey(), (String)entry.getValue());
                }
                catch (RuntimeException e) {
                    this.log.warn("Failed to create a ValuePanel for " + columnName, (Throwable)e);
                }
                if (valuePanel == null) continue;
                this.valuePanels.addAll((Object[])new AbstractValuePanel[]{valuePanel});
            }
            this.root.getChildren().setAll(this.groupPanels());
            this.configureDefaultReturns();
        }));
    }

    public List<AbstractValuePanel> getValuePanels() {
        return new ArrayList<AbstractValuePanel>((Collection<AbstractValuePanel>)this.valuePanels);
    }

    private List<Node> groupPanels() {
        ArrayList<Node> panels = new ArrayList<Node>();
        Config config = StateLookup.getConfig();
        ConfigObject groups = config.getObject("vars.query.column.groups");
        Config groupsConfig = groups.toConfig();
        ArrayList<AbstractValuePanel> vps = new ArrayList<AbstractValuePanel>((Collection<AbstractValuePanel>)this.valuePanels);
        ArrayList used = new ArrayList();
        Set groupNames = groups.keySet();
        for (String name : groupNames) {
            VBox vbox = new VBox();
            vbox.setStyle("-fx-border-color: black");
            List columns = groupsConfig.getStringList(name).stream().map(String::toUpperCase).collect(Collectors.toList());
            List matchingVps = vps.stream().filter(vp -> columns.contains(vp.getValueName().toUpperCase())).sorted((vp1, vp2) -> vp1.getValueName().toUpperCase().compareTo(vp2.getValueName().toUpperCase())).collect(Collectors.toList());
            vbox.getChildren().setAll(matchingVps);
            vbox.getChildren().add(0, (Object)new Label(name));
            panels.add((Node)vbox);
            used.addAll(matchingVps);
        }
        vps.removeAll(used);
        if (!vps.isEmpty()) {
            VBox vbox = new VBox();
            vbox.getChildren().setAll(vps);
            panels.add((Node)vbox);
        }
        return panels;
    }

    private void configureDefaultReturns() {
        Config config = StateLookup.getConfig();
        List defaultReturnNames = config.getStringList("vars.query.column.default.returns");
        for (AbstractValuePanel valuePanel : this.valuePanels) {
            if (!defaultReturnNames.contains(valuePanel.getValueName())) continue;
            valuePanel.setReturned(true);
        }
    }
}

