/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui.sdkfx;

import com.guigarage.sdk.container.WorkbenchView;
import com.guigarage.sdk.form.EditorFormRow;
import com.guigarage.sdk.form.FormLayout;
import com.guigarage.sdk.form.FormRow;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.queryfx.AsyncQueryService;
import vars.queryfx.StateLookup;
import vars.queryfx.beans.QueryParams;
import vars.queryfx.ui.AbstractValuePanel;
import vars.queryfx.ui.ValuePanelFactory;
import vars.queryfx.ui.db.IConstraint;
import vars.shared.rx.RXEventBus;
import vars.shared.rx.messages.FatalExceptionMsg;

public class AdvancedSearchWorkbench
extends WorkbenchView {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ObservableList<AbstractValuePanel> valuePanels = FXCollections.observableArrayList();
    private final AsyncQueryService queryService;
    private final RXEventBus eventBus;
    private final FormLayout formLayout;

    public AdvancedSearchWorkbench(AsyncQueryService queryService, RXEventBus eventBus) {
        this.queryService = queryService;
        this.eventBus = eventBus;
        this.formLayout = new FormLayout();
        this.initialize();
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)this.formLayout);
        scrollPane.setFitToWidth(true);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.setCenterNode((Node)scrollPane);
    }

    public void initialize() {
        ((CompletableFuture)this.queryService.getAnnotationViewMetadata().handle((map, ex) -> {
            if (map != null) {
                return map;
            }
            this.eventBus.send((Object)new FatalExceptionMsg("Could not read annotations view in database", ex));
            return new HashMap();
        })).thenAccept(metadata -> Platform.runLater(() -> {
            ValuePanelFactory factory = new ValuePanelFactory(this.queryService);
            for (Map.Entry entry : metadata.entrySet()) {
                String columnName = (String)entry.getKey();
                if (columnName.toUpperCase().contains("ID_FK")) continue;
                AbstractValuePanel valuePanel = null;
                try {
                    valuePanel = factory.getValuePanel((String)entry.getKey(), (String)entry.getValue());
                }
                catch (RuntimeException e) {
                    this.log.warn("Failed to create a ValuePanel for " + columnName, (Throwable)e);
                }
                if (valuePanel == null) continue;
                this.valuePanels.addAll((Object[])new AbstractValuePanel[]{valuePanel});
            }
            this.groupPanels();
            this.configureDefaultReturns();
        }));
    }

    public List<AbstractValuePanel> getValuePanels() {
        return new ArrayList<AbstractValuePanel>((Collection<AbstractValuePanel>)this.valuePanels);
    }

    private void groupPanels() {
        Config config = StateLookup.getConfig();
        ConfigObject groups = config.getObject("vars.query.column.groups");
        Config groupsConfig = groups.toConfig();
        ArrayList<AbstractValuePanel> vps = new ArrayList<AbstractValuePanel>((Collection<AbstractValuePanel>)this.valuePanels);
        ArrayList used = new ArrayList();
        Set groupNames = groups.keySet();
        for (String name : groupNames) {
            this.formLayout.addHeader(name);
            List columns = groupsConfig.getStringList(name).stream().map(String::toUpperCase).collect(Collectors.toList());
            List matchingVps = vps.stream().filter(vp -> columns.contains(vp.getValueName().toUpperCase())).sorted(Comparator.comparing(vp1 -> vp1.getValueName().toUpperCase())).collect(Collectors.toList());
            matchingVps.stream().forEach(vp -> this.formLayout.add((FormRow)new EditorFormRow(vp.getTitle(), (Node)vp)));
            used.addAll(matchingVps);
        }
        vps.removeAll(used);
        if (!vps.isEmpty()) {
            this.formLayout.addHeader("Other");
            vps.stream().forEach(vp -> this.formLayout.add((FormRow)new EditorFormRow(vp.getTitle(), (Node)vp)));
        }
    }

    private void configureDefaultReturns() {
        Config config = StateLookup.getConfig();
        List defaultReturnNames = config.getStringList("vars.query.column.default.returns").stream().map(String::toUpperCase).collect(Collectors.toList());
        for (AbstractValuePanel valuePanel : this.valuePanels) {
            if (!defaultReturnNames.contains(valuePanel.getValueName().toUpperCase())) continue;
            valuePanel.setReturned(true);
        }
    }

    public QueryParams getQueryParams() {
        List<AbstractValuePanel> vps = this.getValuePanels();
        List<String> returnedColumns = vps.stream().filter(AbstractValuePanel::isReturned).map(AbstractValuePanel::getValueName).collect(Collectors.toList());
        List<IConstraint> constraints = vps.stream().filter(AbstractValuePanel::isConstrained).map(AbstractValuePanel::getConstraint).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return new QueryParams(returnedColumns, constraints);
    }
}

