/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui.db.results;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.knowledgebase.Concept;
import vars.query.results.QueryResults;
import vars.queryfx.AsyncQueryService;

public class QueryResultsDecorator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AsyncQueryService queryService;

    public QueryResultsDecorator(AsyncQueryService queryService) {
        this.queryService = queryService;
    }

    public QueryResults addHierarchy(QueryResults queryResults) {
        Set<String> columnNames = queryResults.getColumnNames();
        Optional<String> column = columnNames.stream().filter(s -> s.equalsIgnoreCase("conceptname")).findFirst();
        if (!column.isPresent()) {
            return queryResults;
        }
        List conceptNameColumn = queryResults.getValues(column.get());
        HashSet uniqueNames = new HashSet();
        uniqueNames.addAll(conceptNameColumn);
        HashMap<Object, String> hierarchy = new HashMap<Object, String>();
        for (Object n : uniqueNames) {
            CompletableFuture<List<Concept>> ancestorsF = this.queryService.findAncestors((String)n);
            try {
                List<Concept> ancestors = ancestorsF.get(5L, TimeUnit.SECONDS);
                String h = ancestors.stream().map(c -> c.getPrimaryConceptName().getName()).collect(Collectors.joining(","));
                hierarchy.put(n, h);
            }
            catch (Exception e) {
                this.log.warn("Failed to find ancestors for " + (String)n, (Throwable)e);
                hierarchy.put(n, null);
            }
        }
        ArrayList<String> hierarchyColumn = new ArrayList<String>(queryResults.getRows());
        for (String n : conceptNameColumn) {
            String h = (String)hierarchy.get(n);
            hierarchyColumn.add(h);
        }
        Map<String, List<Object>> resultsMap = queryResults.copyData();
        resultsMap.put("Hierarchy", hierarchyColumn);
        return new QueryResults(resultsMap);
    }

    private QueryResults addPhylogeny(QueryResults queryResults, List<String> phylogeny) {
        Set<String> columnNames = queryResults.getColumnNames();
        Optional<String> column = columnNames.stream().filter(s -> s.equalsIgnoreCase("conceptname")).findFirst();
        if (!column.isPresent()) {
            return queryResults;
        }
        Map<String, List<Object>> resultsMap = queryResults.copyData();
        String name = column.get();
        List conceptNames = queryResults.getValues(name);
        HashSet uniqueNames = new HashSet(conceptNames);
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        for (String n : uniqueNames) {
            CompletableFuture<List<Concept>> ancestorsF = this.queryService.findAncestors(n);
            try {
                List<Concept> ancestors = ancestorsF.get(5L, TimeUnit.SECONDS);
                List ranks = ancestors.stream().map(c -> {
                    String rankLevel = c.getRankLevel();
                    String rankName = c.getRankName();
                    String rank = null;
                    if (rankLevel != null) {
                        rank = rankLevel + rankName;
                    } else if (rankName != null) {
                        rank = rankName;
                    }
                    return rank;
                }).collect(Collectors.toList());
                ArrayList<String> ancestorNames = new ArrayList<String>(Collections.nCopies(phylogeny.size(), ""));
                for (int i = 0; i < ranks.size(); ++i) {
                    int idx;
                    String rank = (String)ranks.get(i);
                    if (rank == null || (idx = phylogeny.indexOf(rank)) < 0) continue;
                    ancestorNames.set(idx, ancestors.get(i).getPrimaryConceptName().getName());
                }
                map.put(n, ancestorNames);
            }
            catch (Exception e) {
                this.log.warn("Failed to find ancestors for " + n, (Throwable)e);
            }
        }
        for (int i = 0; i < phylogeny.size(); ++i) {
            ArrayList<String> terms = new ArrayList<String>(conceptNames.size());
            for (String cn : conceptNames) {
                String concept;
                List ancestors = (List)map.get(cn);
                boolean added = false;
                if (ancestors != null && (concept = (String)ancestors.get(i)) != null) {
                    terms.add(concept);
                    added = true;
                }
                if (added) continue;
                terms.add("");
            }
            resultsMap.put(phylogeny.get(i), terms);
        }
        return new QueryResults(resultsMap);
    }

    public QueryResults addFullPhylogeny(QueryResults queryResults) {
        ArrayList<String> phylogeny = new ArrayList<String>(){
            {
                this.add("superkingdom");
                this.add("kingdom");
                this.add("infrakingdom");
                this.add("subkingdom");
                this.add("superphylum");
                this.add("phylum");
                this.add("infraphylum");
                this.add("subphylum");
                this.add("superclass");
                this.add("class");
                this.add("infraclass");
                this.add("subclass");
                this.add("superorder");
                this.add("order");
                this.add("infraorder");
                this.add("suborder");
                this.add("superfamily");
                this.add("family");
                this.add("infrafamily");
                this.add("subfamily");
                this.add("supergenus");
                this.add("genus");
                this.add("infragenus");
                this.add("subgenus");
                this.add("superspecies");
                this.add("species");
                this.add("infraspecies");
                this.add("subspecies");
            }
        };
        return this.addPhylogeny(queryResults, (List<String>)phylogeny);
    }

    public QueryResults addBasicPhylogeny(QueryResults queryResults) {
        ArrayList<String> phylogeny = new ArrayList<String>(){
            {
                this.add("kingdom");
                this.add("phylum");
                this.add("class");
                this.add("order");
                this.add("family");
                this.add("genus");
                this.add("species");
            }
        };
        return this.addPhylogeny(queryResults, (List<String>)phylogeny);
    }

    public static QueryResults dropEmptyColumns(QueryResults queryResults) {
        Set<String> columns = queryResults.getColumnNames();
        Map<String, List<Object>> resultsMap = queryResults.copyData();
        boolean isModified = false;
        for (String column : columns) {
            List data = queryResults.getValues(column);
            boolean hasData = false;
            for (Object object : data) {
                if (object == null || object.toString().length() <= 0) continue;
                hasData = true;
                break;
            }
            if (hasData) continue;
            resultsMap.remove(column);
            isModified = true;
        }
        if (isModified) {
            return new QueryResults(resultsMap);
        }
        return queryResults;
    }
}

