/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import vars.queryfx.ui.db.IConstraint;

public class MinMaxConstraint
implements IConstraint {
    private final String columnName;
    private final Number minValue;
    private final Number maxValue;

    public MinMaxConstraint(String columnName, Number minValue, Number maxValue) {
        this.columnName = columnName;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public int bind(PreparedStatement statement, int idx) throws SQLException {
        statement.setDouble(idx, this.minValue.doubleValue());
        statement.setDouble(++idx, this.maxValue.doubleValue());
        return idx + 1;
    }

    @Override
    public String toSQLClause() {
        return "(" + this.columnName + " >= " + this.minValue + " AND " + this.columnName + " <= " + this.maxValue + ")";
    }

    @Override
    public String toPreparedStatementTemplate() {
        return "(" + this.columnName + " >= ? AND " + this.columnName + " <= ?)";
    }
}

