/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui.db;

import com.google.common.base.Preconditions;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import vars.queryfx.ui.db.IConstraint;

public class MinConstraint
implements IConstraint<Number> {
    private final String columnName;
    private final Number minValue;

    public MinConstraint(String columnName, Number minValue) {
        Preconditions.checkArgument((columnName != null && minValue != null ? 1 : 0) != 0);
        this.columnName = columnName;
        this.minValue = minValue;
    }

    @Override
    public int bind(PreparedStatement statement, int idx) throws SQLException {
        statement.setDouble(idx, this.minValue.doubleValue());
        return idx + 1;
    }

    @Override
    public String toSQLClause() {
        return this.columnName + " >= " + this.minValue;
    }

    @Override
    public String toPreparedStatementTemplate() {
        return this.columnName + " >= ?";
    }
}

