/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui.db;

import com.google.common.base.Preconditions;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import vars.queryfx.ui.db.IConstraint;

public class MaxConstraint
implements IConstraint<Number> {
    private final String columnName;
    private final Number maxValue;

    public MaxConstraint(String columnName, Number maxValue) {
        Preconditions.checkArgument((columnName != null && maxValue != null ? 1 : 0) != 0);
        this.columnName = columnName;
        this.maxValue = maxValue;
    }

    @Override
    public int bind(PreparedStatement statement, int idx) throws SQLException {
        statement.setDouble(idx, this.maxValue.doubleValue());
        return idx + 1;
    }

    @Override
    public String toSQLClause() {
        return this.columnName + " <= " + this.maxValue;
    }

    @Override
    public String toPreparedStatementTemplate() {
        return this.columnName + " <= ?";
    }
}

