/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import vars.queryfx.ui.db.IConstraint;

public class LikeConstraint
implements IConstraint<String> {
    private final String columnName;
    private final String value;

    public LikeConstraint(String columnName, String value) {
        this.columnName = columnName;
        this.value = value;
    }

    @Override
    public int bind(PreparedStatement statement, int idx) throws SQLException {
        statement.setString(idx, '%' + this.value + '%');
        return idx + 1;
    }

    @Override
    public String toSQLClause() {
        return this.columnName + " LIKE '%" + this.value + "%'";
    }

    @Override
    public String toPreparedStatementTemplate() {
        return this.columnName + " LIKE ?";
    }
}

