/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui.db;

import com.google.common.base.Preconditions;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import vars.queryfx.ui.db.IConstraint;

public class InConstraint
implements IConstraint<List<String>> {
    private final String columnName;
    private final List<String> values;

    public InConstraint(String columnName, List<String> values) {
        Preconditions.checkArgument((columnName != null ? 1 : 0) != 0);
        Preconditions.checkArgument((values != null && !values.isEmpty() ? 1 : 0) != 0, (Object)"Check your value arg! null and empty values are not allowed");
        this.columnName = columnName;
        this.values = new ArrayList<String>(values);
    }

    public List<String> getPreparedStatementBindingValues() {
        return new ArrayList<String>(this.values);
    }

    @Override
    public int bind(PreparedStatement statement, int idx) throws SQLException {
        for (String v : this.values) {
            statement.setString(idx, "%" + v + "%");
            ++idx;
        }
        return idx;
    }

    @Override
    public String toSQLClause() {
        if (this.values.size() == 1) {
            return this.columnName + " = '" + this.values.get(0) + "'";
        }
        return this.columnName + " IN " + this.values.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", ", "(", ")"));
    }

    @Override
    public String toPreparedStatementTemplate() {
        if (this.values.size() == 1) {
            return this.columnName + " = ?";
        }
        return this.columnName + " IN " + this.values.stream().map(s -> "?").collect(Collectors.joining(", ", "(", ")"));
    }
}

