/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import vars.queryfx.StateLookup;
import vars.queryfx.ui.db.IConstraint;

public class DateBoundsConstraint
implements IConstraint<Date> {
    private final String columnName;
    private final Date minDate;
    private final Date maxDate;

    public DateBoundsConstraint(String columnName, Date minDate, Date maxDate) {
        this.columnName = columnName;
        this.minDate = minDate;
        this.maxDate = maxDate;
    }

    @Override
    public int bind(PreparedStatement statement, int idx) throws SQLException {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        statement.setDate(idx, new java.sql.Date(this.minDate.getTime()), cal);
        statement.setDate(++idx, new java.sql.Date(this.maxDate.getTime()), cal);
        return idx + 1;
    }

    @Override
    public String toSQLClause() {
        DateFormat df = StateLookup.getUTCDateFormat();
        return this.columnName + " BETWEEN '" + df.format(this.minDate) + "' AND '" + df.format(this.maxDate) + "'";
    }

    @Override
    public String toPreparedStatementTemplate() {
        return this.columnName + " BETWEEN ? AND ?";
    }
}

