/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import vars.ILink;
import vars.queryfx.beans.ResolvedConceptSelection;
import vars.queryfx.ui.db.IConstraint;

public class ConceptConstraint
implements IConstraint<ResolvedConceptSelection> {
    private final ResolvedConceptSelection resolvedConceptSelection;
    private final List<String> conceptNames;
    private final boolean hasLinkName;
    private final boolean hasToConcept;
    private final Boolean hasLinkValue;

    public ConceptConstraint(ResolvedConceptSelection resolvedConceptSelection) {
        ILink link;
        this.resolvedConceptSelection = resolvedConceptSelection;
        this.conceptNames = new ArrayList<String>();
        if (!this.isWildCard(resolvedConceptSelection.getConceptName())) {
            this.conceptNames.add(resolvedConceptSelection.getConceptName());
            this.conceptNames.addAll(resolvedConceptSelection.getConcepts());
        }
        if ((link = resolvedConceptSelection.getLink()) != null) {
            this.hasLinkName = !this.isWildCard(link.getLinkName());
            this.hasToConcept = !this.isWildCard(link.getToConcept());
            this.hasLinkValue = !this.isWildCard(link.getLinkValue());
        } else {
            this.hasLinkName = false;
            this.hasToConcept = false;
            this.hasLinkValue = false;
        }
    }

    private boolean isWildCard(String wc) {
        String u = wc.toUpperCase();
        return u.equals("*") || u.equals("nil");
    }

    @Override
    public int bind(PreparedStatement statement, int idx) throws SQLException {
        ILink link = this.resolvedConceptSelection.getLink();
        if (!this.conceptNames.isEmpty()) {
            for (String s : this.conceptNames) {
                statement.setString(idx, s);
                ++idx;
            }
            if (this.hasToConcept) {
                statement.setString(idx, link.getToConcept());
            } else {
                for (String s : this.conceptNames) {
                    statement.setString(idx, s);
                    ++idx;
                }
            }
        } else if (this.hasToConcept) {
            statement.setString(idx, link.getToConcept());
            ++idx;
        }
        if (this.hasLinkName) {
            statement.setString(idx, link.getLinkName());
            ++idx;
        }
        if (this.hasLinkValue.booleanValue()) {
            statement.setString(idx, link.getLinkValue());
            ++idx;
        }
        return idx;
    }

    @Override
    public String toSQLClause() {
        if (this.conceptNames.isEmpty() && !this.hasLinkName && !this.hasToConcept && !this.hasLinkValue.booleanValue()) {
            return "";
        }
        ILink link = this.resolvedConceptSelection.getLink();
        StringBuilder sb = new StringBuilder("(");
        if (!this.conceptNames.isEmpty()) {
            String cns = this.conceptNames.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", "));
            sb.append("(ConceptName IN (");
            sb.append(cns);
            sb.append(")");
            if (this.hasToConcept) {
                sb.append(" AND ToConcept = '").append(link.getToConcept()).append("'");
            } else {
                sb.append(" OR ToConcept IN (").append(cns).append(")");
            }
            sb.append(")");
        } else if (this.hasToConcept) {
            sb.append("ToConcept = '").append(link.getToConcept()).append("'");
        }
        if (this.hasLinkName) {
            sb.append(" AND LinkName = '").append(link.getLinkName()).append("'");
        }
        if (this.hasLinkValue.booleanValue()) {
            sb.append(" AND LinkValue = '").append(link.getLinkValue()).append("'");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String toPreparedStatementTemplate() {
        if (this.conceptNames.isEmpty() && !this.hasLinkName && !this.hasToConcept && !this.hasLinkValue.booleanValue()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("(");
        if (!this.conceptNames.isEmpty()) {
            String cns = this.conceptNames.stream().map(s -> "?").collect(Collectors.joining(", "));
            sb.append("(ConceptName IN (");
            sb.append(cns);
            sb.append(")");
            if (this.hasToConcept) {
                sb.append(" AND ToConcept = ? ");
            } else {
                sb.append(" OR ToConcept IN (").append(cns).append(")");
            }
            sb.append(")");
        } else if (this.hasToConcept) {
            sb.append("ToConcept = ?");
        }
        if (this.hasLinkName) {
            sb.append(" AND LinkName = ?");
        }
        if (this.hasLinkValue.booleanValue()) {
            sb.append(" AND LinkValue = ?");
        }
        sb.append(")");
        return sb.toString();
    }
}

