/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui.controllers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mbari.util.Tuple2;
import vars.query.results.QueryResults;
import vars.query.results.QueryResultsUtilities;
import vars.query.results.SaveImagesFn;
import vars.query.results.SaveResultsAsKMLFn;
import vars.queryfx.rx.messages.SaveAsJSONMsg;
import vars.queryfx.rx.messages.SaveAsKMLMsg;
import vars.queryfx.rx.messages.SaveAsTextMsg;
import vars.queryfx.rx.messages.SaveImagesMsg;
import vars.shared.rx.RXEventBus;
import vars.shared.rx.messages.NonFatalExceptionMsg;

public class SaveResultsController {
    private final RXEventBus eventBus;
    private final Executor executor;

    public SaveResultsController(RXEventBus eventBus, Executor executor) {
        this.eventBus = eventBus;
        this.executor = executor;
        eventBus.toObserverable().ofType(SaveAsTextMsg.class).subscribe(msg -> this.saveAsText(msg.getTarget(), msg.getQueryResults(), msg.getSql()));
        eventBus.toObserverable().ofType(SaveAsKMLMsg.class).subscribe(msg -> this.saveAsKML(msg.getTarget(), msg.getQueryResults(), msg.getSql()));
        eventBus.toObserverable().ofType(SaveImagesMsg.class).subscribe(msg -> this.saveImages(msg.getTargetDir(), msg.getQueryResults(), msg.getProgressFn()));
        eventBus.toObserverable().ofType(SaveAsJSONMsg.class).subscribe(msg -> this.saveAsJSON(msg.getTarget(), msg.getQueryResults()));
    }

    public void saveAsText(File file, QueryResults queryResults, Optional<String> sql) {
        this.executor.execute(() -> {
            String text = QueryResultsUtilities.createMetadataString(queryResults, sql);
            String[] lines = text.split("\n");
            String header = Arrays.stream(lines).map(s -> "# " + s).collect(Collectors.joining("\n"));
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(file));
                out.write(header);
                out.write("\n");
                Tuple2<List<String>, List<String[]>> content = queryResults.toRowOrientedData();
                List columnNames = (List)content.getA();
                List rows = (List)content.getB();
                String columns = columnNames.stream().collect(Collectors.joining("\t"));
                out.write(columns);
                out.write("\n");
                for (String[] r : rows) {
                    String rs = Arrays.stream(r).collect(Collectors.joining("\t"));
                    out.write(rs);
                    out.write("\n");
                }
                out.close();
            }
            catch (Exception e) {
                this.eventBus.send((Object)new NonFatalExceptionMsg("Unable to save results to " + file.getAbsolutePath(), (Throwable)e));
            }
        });
    }

    public void saveAsKML(File file, QueryResults queryResults, Optional<String> sql) {
        SaveResultsAsKMLFn fn = new SaveResultsAsKMLFn(this.executor, file, queryResults, sql);
        fn.apply();
    }

    public void saveImages(File targetDir, QueryResults queryResults, Consumer<Double> progressFn) {
        SaveImagesFn fn = new SaveImagesFn(this.executor, targetDir, queryResults, progressFn);
        fn.apply();
    }

    public void saveAsJSON(File file, QueryResults queryResults) {
    }
}

