/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui.controllers;

import com.guigarage.sdk.util.MaterialDesignButton;
import java.io.File;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import vars.query.results.QueryResults;
import vars.queryfx.rx.messages.NewQueryResultsMsg;
import vars.queryfx.rx.messages.SaveAsKMLMsg;
import vars.queryfx.rx.messages.SaveAsTextMsg;
import vars.queryfx.rx.messages.SaveImagesMsg;
import vars.queryfx.ui.QueryResultsTableView;
import vars.shared.rx.RXEventBus;

public class QueryResultsUIController {
    private final RXEventBus eventBus;

    public QueryResultsUIController(RXEventBus eventBus) {
        this.eventBus = eventBus;
        eventBus.toObserverable().filter(msg -> msg instanceof NewQueryResultsMsg).map(msg -> (NewQueryResultsMsg)msg).subscribe(msg -> this.showQueryResults(msg.getStage(), msg.getQueryResults(), msg.getSql()));
    }

    public CompletableFuture<Stage> newQueryStage() {
        CompletableFuture<Stage> stageF = new CompletableFuture<Stage>();
        Platform.runLater(() -> {
            Stage stage = new Stage();
            Instant toc = Instant.now();
            Label label0 = new Label("Executing query ... ");
            Label label1 = new Label("    started at " + toc.toString());
            Label label2 = new Label("    ...");
            VBox hBox = new VBox(new Node[]{label0, label1, label2});
            Scene scene = new Scene((Parent)hBox);
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), e -> {
                Instant tic = Instant.now();
                java.time.Duration d = java.time.Duration.between(toc, tic);
                String s = String.format("%5.0f", (double)d.toMillis() / 1000.0);
                label2.setText("    Elapsed time: " + s + " seconds");
            }, new KeyValue[0])});
            timeline.setCycleCount(-1);
            timeline.play();
            stage.setScene(scene);
            stage.show();
            stageF.complete(stage);
        });
        return stageF;
    }

    public void showQueryResults(Stage stage, QueryResults queryResults, Optional<String> sql) {
        Platform.runLater(() -> {
            TabPane tabPane = new TabPane();
            BorderPane borderPane = new BorderPane((Node)tabPane);
            Tab resultsTab = new Tab("Data");
            resultsTab.setClosable(false);
            TableView<String[]> tableView = QueryResultsTableView.newTableView(queryResults);
            resultsTab.setContent(tableView);
            tabPane.getTabs().add((Object)resultsTab);
            sql.ifPresent(s -> {
                String text = this.createMetadataString(queryResults, sql);
                Tab queryTab = new Tab("Query");
                queryTab.setClosable(false);
                TextArea textArea = new TextArea(text);
                queryTab.setContent((Node)new BorderPane((Node)textArea));
                tabPane.getTabs().add((Object)queryTab);
            });
            ToolBar toolBar = new ToolBar();
            ProgressIndicator progressIndicator = new ProgressIndicator(0.0);
            progressIndicator.setVisible(false);
            MaterialDesignButton saveButton = new MaterialDesignButton("Save");
            saveButton.setOnAction(v -> {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setInitialFileName("vars_query.txt");
                File saveFile = fileChooser.showSaveDialog((Window)stage);
                if (saveFile != null) {
                    this.eventBus.send((Object)new SaveAsTextMsg(saveFile, queryResults, sql));
                }
            });
            MaterialDesignButton saveKMLButton = new MaterialDesignButton("Save KML");
            saveKMLButton.setOnAction(v -> {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setInitialFileName("vars_query.kml");
                File saveFile = fileChooser.showSaveDialog((Window)stage);
                if (saveFile != null) {
                    this.eventBus.send((Object)new SaveAsKMLMsg(saveFile, queryResults, sql));
                }
            });
            MaterialDesignButton saveImagesButton = new MaterialDesignButton("Save Images");
            saveImagesButton.setOnAction(arg_0 -> this.lambda$null$10(stage, queryResults, (Button)saveImagesButton, progressIndicator, arg_0));
            toolBar.getItems().addAll((Object[])new Node[]{saveButton, saveKMLButton, saveImagesButton, progressIndicator});
            borderPane.setTop((Node)toolBar);
            Scene scene = new Scene((Parent)borderPane);
            stage.setScene(scene);
        });
    }

    public String createMetadataString(QueryResults queryResults, Optional<String> sql) {
        StringBuilder text = new StringBuilder(Instant.now().toString());
        sql.ifPresent(s -> text.append("\n\n").append("DATABASE\n\t").append("\n").append("QUERY\n\t").append((String)s).append("\n\n").append("TOTAL RECORDS: ").append(queryResults.getRows()));
        return text.toString();
    }

    private /* synthetic */ void lambda$null$10(Stage stage, QueryResults queryResults, Button saveImagesButton, ProgressIndicator progressIndicator, ActionEvent v) {
        DirectoryChooser dirChooser = new DirectoryChooser();
        dirChooser.setTitle("Select directory to save images into");
        File saveDir = dirChooser.showDialog((Window)stage);
        if (saveDir != null) {
            this.eventBus.send((Object)new SaveImagesMsg(saveDir, queryResults, d -> Platform.runLater(() -> {
                boolean showProgress = d > 0.0;
                saveImagesButton.setDisable(showProgress);
                progressIndicator.setVisible(showProgress);
                progressIndicator.setProgress(d.doubleValue());
            })));
        }
    }
}

