/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui.controllers;

import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javafx.application.Platform;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.VARSException;
import vars.query.results.AssociationColumnRemappingDecorator;
import vars.query.results.CoalescingDecorator;
import vars.query.results.QueryResults;
import vars.queryfx.AsyncQueryService;
import vars.queryfx.beans.ConceptSelection;
import vars.queryfx.beans.ResolvedConceptSelection;
import vars.queryfx.beans.ResultsCustomization;
import vars.queryfx.rx.messages.ExecuteSearchMsg;
import vars.queryfx.rx.messages.NewConceptSelectionMsg;
import vars.queryfx.rx.messages.NewQueryResultsMsg;
import vars.queryfx.rx.messages.NewResolvedConceptSelectionMsg;
import vars.queryfx.ui.controllers.QueryResultsUIController;
import vars.queryfx.ui.db.ConceptConstraint;
import vars.queryfx.ui.db.IConstraint;
import vars.queryfx.ui.db.PreparedStatementGenerator;
import vars.queryfx.ui.db.SQLStatementGenerator;
import vars.queryfx.ui.db.results.QueryResultsDecorator;
import vars.shared.rx.RXEventBus;

public class AppController {
    private final AsyncQueryService queryService;
    private final RXEventBus eventBus;
    private final Executor executor;
    private final QueryResultsUIController uiController;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public AppController(AsyncQueryService queryService, RXEventBus eventBus, Executor executor) {
        this.queryService = queryService;
        this.eventBus = eventBus;
        this.executor = executor;
        this.uiController = new QueryResultsUIController(eventBus);
        eventBus.toObserverable().filter(msg -> msg instanceof NewConceptSelectionMsg).map(msg -> (NewConceptSelectionMsg)msg).subscribe(msg -> this.addConceptSelection(msg.getConceptSelection()));
        eventBus.toObserverable().filter(msg -> msg instanceof ExecuteSearchMsg).map(msg -> (ExecuteSearchMsg)msg).subscribe(this::executeSearch);
    }

    protected void addConceptSelection(ConceptSelection conceptSelection) {
        CompletableFuture<Optional<URL>> urlF = this.queryService.resolveImageURL(conceptSelection.getConceptName());
        ((CompletableFuture)this.queryService.resolveConceptSelection(conceptSelection).thenCombineAsync(urlF, (rcs, urlOpt) -> {
            if (urlOpt.isPresent()) {
                Platform.runLater(() -> {
                    Image image = new Image(((URL)urlOpt.get()).toExternalForm(), true);
                    rcs.imageProperty().set((Object)image);
                });
            }
            return rcs;
        })).thenAccept(rcs -> this.eventBus.send((Object)new NewResolvedConceptSelectionMsg((ResolvedConceptSelection)rcs)));
    }

    protected void executeSearch(ExecuteSearchMsg msg) {
        SQLStatementGenerator sqlGen = new SQLStatementGenerator();
        String sql = sqlGen.getSQLStatement(msg.getQueryReturns(), msg.getConceptConstraints(), msg.getQueryConstraints(), msg.getResultsCustomization());
        this.log.debug("Executing: " + sql);
        System.out.println(sql);
        CompletableFuture<Stage> stageF = this.uiController.newQueryStage();
        CompletableFuture<QueryResults> queryResultsF = this.runQuery(msg.getQueryReturns(), msg.getConceptConstraints(), msg.getQueryConstraints(), msg.getResultsCustomization());
        stageF.thenAcceptBothAsync(queryResultsF, (stage, queryResults) -> this.eventBus.send((Object)new NewQueryResultsMsg((Stage)stage, (QueryResults)queryResults, Optional.of(sql))), this.executor);
    }

    public CompletableFuture<QueryResults> runQuery(List<String> queryReturns, List<ConceptConstraint> conceptConstraints, List<IConstraint> queryConstraints, ResultsCustomization resultsCustomization) {
        return CompletableFuture.supplyAsync(() -> {
            PreparedStatementGenerator psg = new PreparedStatementGenerator();
            try {
                String template = psg.getPreparedStatementTemplate(queryReturns, conceptConstraints, queryConstraints, resultsCustomization);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("PreparedStatement Template: " + template);
                }
                Connection connection = this.queryService.getAnnotationConnection();
                PreparedStatement preparedStatement = connection.prepareStatement(template);
                psg.bind(preparedStatement, conceptConstraints, queryConstraints);
                QueryResults queryResults = QueryResults.fromResultSet(preparedStatement.executeQuery());
                if (resultsCustomization.isCategorizeAssociations()) {
                    queryResults = AssociationColumnRemappingDecorator.apply(queryResults);
                }
                queryResults = CoalescingDecorator.coalesce(queryResults, "ObservationID_FK");
                QueryResultsDecorator queryResultsDecorator = new QueryResultsDecorator(this.queryService);
                if (resultsCustomization.isConceptHierarchy()) {
                    queryResults = queryResultsDecorator.addHierarchy(queryResults);
                }
                if (resultsCustomization.isDetailedPhylogeny()) {
                    queryResults = queryResultsDecorator.addFullPhylogeny(queryResults);
                } else if (resultsCustomization.isBasicPhylogeny()) {
                    queryResults = queryResultsDecorator.addBasicPhylogeny(queryResults);
                }
                return queryResults;
            }
            catch (SQLException e) {
                throw new VARSException("Failed to execute prepared statement", e);
            }
        }, this.executor);
    }
}

