/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import vars.queryfx.AsyncQueryService;
import vars.queryfx.ui.AbstractValuePanel;
import vars.queryfx.ui.BooleanValuePanel;
import vars.queryfx.ui.DateValuePanel;
import vars.queryfx.ui.NumberValuePanel;
import vars.queryfx.ui.StringValuePanel;

public class ValuePanelFactory {
    private final AsyncQueryService queryService;

    public ValuePanelFactory(AsyncQueryService queryService) {
        this.queryService = queryService;
    }

    public AbstractValuePanel getValuePanel(String name, String type) {
        AbstractValuePanel valuePanel = null;
        valuePanel = type.equals("java.lang.String") ? this.newStringValuePanel(name) : (type.equals("java.sql.Timestamp") ? this.newDateValuePanel(name) : (type.equals("java.lang.Boolean") ? this.newBooleanValuePanel(name) : this.newNumberValuePanel(name)));
        return valuePanel;
    }

    private StringValuePanel newStringValuePanel(String name) {
        StringValuePanel valuePanel = new StringValuePanel(name);
        valuePanel.setOnScan(() -> this.queryService.getAnnotationViewsUniqueValuesForColumn(name).thenAccept(c -> {
            Collection values = c;
            valuePanel.setValues(values);
        }));
        return valuePanel;
    }

    private NumberValuePanel newNumberValuePanel(String name) {
        NumberValuePanel valuePanel = new NumberValuePanel(name);
        valuePanel.setOnScan(() -> this.queryService.getAnnotationViewsMinAndMaxForColumn(name).thenAccept(minMax -> {
            if (minMax != null && minMax.size() == 2) {
                valuePanel.setMinValue((Number)minMax.get(0));
                valuePanel.setMaxValue((Number)minMax.get(1));
            }
        }));
        return valuePanel;
    }

    private DateValuePanel newDateValuePanel(String name) {
        DateValuePanel valuePanel = new DateValuePanel(name);
        valuePanel.setOnScan(() -> this.queryService.getAnnotationViewsMinAndMaxDatesforColumn(name).thenAccept(minMax -> {
            if (minMax != null && minMax.size() == 2) {
                LocalDateTime start = LocalDateTime.ofInstant(((Date)minMax.get(0)).toInstant(), ZoneId.of("UTC"));
                LocalDateTime end = LocalDateTime.ofInstant(((Date)minMax.get(1)).toInstant(), ZoneId.of("UTC"));
                valuePanel.setStartDate(start);
                valuePanel.setEndDate(end);
            }
        }));
        return valuePanel;
    }

    private BooleanValuePanel newBooleanValuePanel(String name) {
        BooleanValuePanel valuePanel = new BooleanValuePanel(name);
        return valuePanel;
    }
}

