/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import vars.queryfx.ui.AbstractValuePanel;
import vars.queryfx.ui.db.IConstraint;
import vars.queryfx.ui.db.InConstraint;
import vars.queryfx.ui.db.LikeConstraint;

public class StringValuePanel
extends AbstractValuePanel {
    private ListView<String> listView;
    private TextField textField;
    private ToggleButton toggleButton;

    public StringValuePanel(String valueName) {
        super(valueName);
        Region btnSpacer = new Region();
        btnSpacer.setMinWidth(10.0);
        HBox.setHgrow((Node)btnSpacer, (Priority)Priority.NEVER);
        this.getChildren().addAll((Object[])new Node[]{this.getTextField(), btnSpacer, this.getToggleButton()});
    }

    private ListView<String> getListView() {
        if (this.listView == null) {
            this.listView = new ListView();
            this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            this.listView.getSelectionModel().getSelectedItems().addListener(c -> {
                if (this.listView.getSelectionModel().getSelectedItems().size() > 0) {
                    this.getConstrainCheckBox().setSelected(true);
                }
            });
            this.listView.itemsProperty().addListener((obs, oldVal, newVal) -> {
                int visibleRows = 6;
                if (newVal.size() > 20) {
                    visibleRows = 10;
                } else if (newVal.size() == 0) {
                    visibleRows = 3;
                }
                this.listView.prefHeightProperty().set(this.getTextField().getHeight() * (double)visibleRows);
            });
            HBox.setHgrow(this.listView, (Priority)Priority.ALWAYS);
        }
        return this.listView;
    }

    private TextField getTextField() {
        if (this.textField == null) {
            this.textField = new TextField();
            this.textField.textProperty().addListener((obs, oldVal, newVal) -> this.getConstrainCheckBox().setSelected(newVal != null && !newVal.isEmpty()));
            HBox.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
        }
        return this.textField;
    }

    private ToggleButton getToggleButton() {
        if (this.toggleButton == null) {
            this.toggleButton = new ToggleButton("Scan");
        }
        return this.toggleButton;
    }

    public void setOnScan(Runnable runnable) {
        this.getToggleButton().selectedProperty().addListener((obs, oldVal, newVal) -> {
            ListView<String> node;
            if (newVal.booleanValue()) {
                runnable.run();
                node = this.getListView();
            } else {
                node = this.getTextField();
            }
            this.getChildren().remove(2);
            this.getChildren().add(2, node);
        });
    }

    public List<String> getSelectedValues() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.getToggleButton().isSelected()) {
            list.addAll((Collection<String>)this.getListView().getItems().sorted());
        } else {
            String text = this.getTextField().getText();
            if (text != null && !text.isEmpty()) {
                list.add(text);
            }
        }
        return list;
    }

    public void setValues(Collection<String> values) {
        this.getListView().getItems().clear();
        this.getListView().getItems().addAll(values);
    }

    @Override
    public Optional<IConstraint> getConstraint() {
        List<String> selectedValues = this.getSelectedValues();
        Optional<IConstraint> constraint = Optional.empty();
        if (this.isConstrained() && !selectedValues.isEmpty()) {
            constraint = this.getToggleButton().isSelected() ? Optional.of(new InConstraint(this.getValueName(), selectedValues)) : Optional.of(new LikeConstraint(this.getValueName(), selectedValues.get(0)));
        }
        return constraint;
    }
}

