/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.ToolBar;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.mbari.net.URLUtilities;
import org.mbari.util.Tuple2;
import vars.query.results.QueryResults;
import vars.shared.javafx.application.ImageFX;
import vars.shared.javafx.stage.ImageStage;

public class QueryResultsTableView {
    public static TableView<String[]> newTableView(QueryResults queryResults) {
        Tuple2<List<String>, List<String[]>> rowOrientedData = queryResults.toRowOrientedData();
        List columnNames = (List)rowOrientedData.getA();
        List data = (List)rowOrientedData.getB();
        TableView<String[]> tableView = QueryResultsTableView.getTableView(columnNames);
        tableView.getItems().addAll((Collection)data);
        return tableView;
    }

    private static TableView<String[]> getTableView(List<String> columnNames) {
        TableView tableView = new TableView();
        for (int i = 0; i < columnNames.size(); ++i) {
            TableColumn column = new TableColumn(columnNames.get(i));
            int j = i;
            column.setCellValueFactory(param -> new SimpleStringProperty(((String[])param.getValue())[j]));
            tableView.getColumns().add(i, (Object)column);
        }
        String uuid = UUID.randomUUID().toString();
        URL url = QueryResultsTableView.class.getResource("/vars/queryfx/images/404-page-not-found.jpg");
        ImageStageExt imageStageExt = null;
        try {
            ImageStage imageStage = (ImageStage)ImageFX.namedWindow((String)uuid, (String)url.toExternalForm()).get(3L, TimeUnit.SECONDS);
            imageStageExt = new ImageStageExt(imageStage);
        }
        catch (Exception imageStage) {
            // empty catch block
        }
        FileChooser fileChooser = new FileChooser();
        ImageStageExt ext = imageStageExt;
        Function<String[], Void> showImageFn = rowItem -> {
            List urls = Arrays.stream(rowItem).filter(s -> s.startsWith("http") || s.startsWith("file")).collect(Collectors.toList());
            if (!urls.isEmpty() && ext != null) {
                String imageLocation = (String)urls.get(0);
                Image image = new Image(imageLocation);
                ext.saveButton.setOnAction(v -> {
                    try {
                        URL imageUrl = new URL(imageLocation);
                        fileChooser.setInitialFileName(URLUtilities.toFilename((URL)imageUrl));
                        File selectedFile = fileChooser.showSaveDialog((Window)ext.imageStage);
                        if (selectedFile != null) {
                            URLUtilities.copy((URL)new URL(imageLocation), (File)selectedFile);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                ext.imageStage.setImage(image);
                ext.imageStage.show();
            }
            return null;
        };
        tableView.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(e -> {
                if (e.getClickCount() == 2) {
                    showImageFn.apply((String[])row.getItem());
                }
            });
            return row;
        });
        tableView.setOnKeyPressed(event -> {
            String[] item;
            if (event.getCode() == KeyCode.ENTER && (item = (String[])tableView.getSelectionModel().getSelectedItem()) != null) {
                showImageFn.apply(item);
            }
        });
        return tableView;
    }

    private static class ImageStageExt {
        final Button saveButton;
        final ImageStage imageStage;

        public ImageStageExt(ImageStage imageStage) {
            this.imageStage = imageStage;
            BorderPane root = imageStage.getRoot();
            root.setStyle("-fx-background-color: black");
            this.saveButton = new Button("Save");
            ToolBar toolBar = new ToolBar(new Node[]{this.saveButton});
            toolBar.setStyle("-fx-background-color: black");
            root.setTop((Node)toolBar);
        }
    }
}

