/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui;

import com.guigarage.sdk.Application;
import com.guigarage.sdk.action.Action;
import com.guigarage.sdk.container.WorkbenchView;
import com.guigarage.sdk.footer.ActionFooter;
import com.guigarage.sdk.form.EditorType;
import com.guigarage.sdk.form.FormLayout;
import com.guigarage.sdk.list.MediaList;
import com.guigarage.sdk.util.DefaultMedia;
import com.guigarage.sdk.util.FontBasedIcon;
import java.util.Date;
import java.util.TimeZone;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.paint.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.queryfx.ui.App;
import vars.queryfx.ui.AppIcons;

public class QueryAppMockup {
    private static Logger log;

    public static void main(String[] args) {
        System.setProperty("user.timezone", "UTC");
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        Thread.setDefaultUncaughtExceptionHandler((thread, e) -> {
            Logger log = LoggerFactory.getLogger(thread.getClass());
            log.error("Exception in thread [" + thread.getName() + "]", e);
        });
        Logger mainLog = QueryAppMockup.getLog();
        if (mainLog.isInfoEnabled()) {
            Date date = new Date();
            mainLog.info("This application was launched at " + date.toString());
        }
        Application app = new Application();
        app.setTitle("VARS Query");
        app.setToolbarBackgroundImage("http://www.mbari.org/art/global/header/rotator.php");
        app.setStopCallback(() -> System.exit(0));
        app.addToolbarItem(new Action((FontBasedIcon)AppIcons.PLAY, "Run Search"));
        app.setBaseColor(new Color(0.10588235294117647, 0.30196078431372547, 0.5764705882352941, 1.0));
        app.addMenuEntry(new Action((FontBasedIcon)AppIcons.SEARCH, "Basic Search", () -> QueryAppMockup.showSimpleSearch(app)));
        app.addMenuEntry(new Action((FontBasedIcon)AppIcons.SEARCH_PLUS, "Advanced Search", () -> QueryAppMockup.showAdvancedSearch(app)));
        app.addMenuEntry(new Action((FontBasedIcon)AppIcons.GEARS, "Customize Results", () -> QueryAppMockup.showCustomizeResults(app)));
        QueryAppMockup.showSimpleSearch(app);
        app.show();
    }

    private static Logger getLog() {
        if (log == null) {
            log = LoggerFactory.getLogger(App.class);
        }
        return log;
    }

    private static void showSimpleSearch(Application app) {
        WorkbenchView view = new WorkbenchView();
        MediaList list = new MediaList();
        list.getItems().add((Object)new DefaultMedia("Chiroteuthis", "and descendants", "http://dsg.mbari.org/images/dsg/external/Mollusca/Cephalopoda/Chiroteuthis_calyx_01.png"));
        ActionFooter footer = new ActionFooter();
        footer.addAction(new Action((FontBasedIcon)AppIcons.TRASH, "Remove all"));
        view.setFooterNode((Node)footer);
        view.setCenterNode((Node)list);
        app.setWorkbench((Node)view);
        app.clearGlobalActions();
        app.addGlobalAction(new Action((FontBasedIcon)AppIcons.PLUS, () -> {}));
    }

    private static void showAdvancedSearch(Application app) {
        WorkbenchView view = new WorkbenchView();
        FormLayout formLayout = new FormLayout();
        formLayout.addHeader("Advanced Search");
        formLayout.addField("Name");
        formLayout.addActions(new Action[]{new Action("Save"), new Action("Cancel")});
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)formLayout);
        scrollPane.setFitToWidth(true);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        view.setCenterNode((Node)scrollPane);
        app.setWorkbench((Node)view);
        app.clearGlobalActions();
    }

    private static void showCustomizeResults(Application app) {
        WorkbenchView view = new WorkbenchView();
        FormLayout formLayout = new FormLayout();
        formLayout.addHeader("Customize Results");
        formLayout.addField("Return related associations", EditorType.CHECKBOX);
        formLayout.addField("Return concurrent observations", EditorType.CHECKBOX);
        formLayout.addField("Return concept hierarchy", EditorType.CHECKBOX);
        formLayout.addField("Return basic organism phylogeny", EditorType.CHECKBOX);
        formLayout.addField("Return detailed organism phylogeny", EditorType.CHECKBOX);
        formLayout.addField("Categorize associations into columns", EditorType.CHECKBOX);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)formLayout);
        scrollPane.setFitToWidth(true);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        view.setCenterNode((Node)scrollPane);
        app.setWorkbench((Node)view);
        app.clearGlobalActions();
    }
}

