/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui;

import com.guigarage.sdk.util.MaterialDesignButton;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import vars.queryfx.ui.AbstractValuePanel;
import vars.queryfx.ui.db.IConstraint;
import vars.queryfx.ui.db.MaxConstraint;
import vars.queryfx.ui.db.MinConstraint;
import vars.queryfx.ui.db.MinMaxConstraint;

public class NumberValuePanel
extends AbstractValuePanel {
    private TextField minTextField;
    private TextField maxTextField;
    private Button scanButton;

    public NumberValuePanel(String valueName) {
        super(valueName);
        Region spacer = new Region();
        spacer.setMinWidth(20.0);
        HBox.setHgrow((Node)spacer, (Priority)Priority.NEVER);
        Region btnSpacer = new Region();
        btnSpacer.setMinWidth(10.0);
        HBox.setHgrow((Node)btnSpacer, (Priority)Priority.NEVER);
        this.getChildren().addAll((Object[])new Node[]{this.getMinTextField(), spacer, this.getMaxTextField(), btnSpacer, this.getScanButton()});
    }

    private TextField getMinTextField() {
        if (this.minTextField == null) {
            this.minTextField = new TextField();
            this.minTextField.setPromptText("Enter minimum value");
            this.minTextField.textProperty().addListener((obs, oldVal, newVal) -> {
                boolean selected = newVal != null && !newVal.isEmpty();
                this.getConstrainCheckBox().setSelected(selected);
            });
            this.minTextField.setOnKeyPressed(e -> {
                KeyCode keyCode = e.getCode();
                if (keyCode.isLetterKey()) {
                    e.consume();
                }
            });
            HBox.setHgrow((Node)this.minTextField, (Priority)Priority.ALWAYS);
        }
        return this.minTextField;
    }

    private TextField getMaxTextField() {
        if (this.maxTextField == null) {
            this.maxTextField = new TextField();
            this.maxTextField.setPromptText("Enter maximum value");
            this.maxTextField.textProperty().addListener((obs, oldVal, newVal) -> {
                boolean selected = newVal != null && !newVal.isEmpty();
                this.getConstrainCheckBox().setSelected(selected);
            });
            this.maxTextField.setOnKeyPressed(e -> {
                KeyCode keyCode = e.getCode();
                if (keyCode.isLetterKey()) {
                    e.consume();
                }
            });
            HBox.setHgrow((Node)this.maxTextField, (Priority)Priority.ALWAYS);
        }
        return this.maxTextField;
    }

    protected Button getScanButton() {
        if (this.scanButton == null) {
            this.scanButton = new MaterialDesignButton("Scan");
        }
        return this.scanButton;
    }

    public void setOnScan(Runnable runnable) {
        this.scanButton.setOnAction(eventHandler -> runnable.run());
    }

    public String getMinValue() {
        return this.getMinTextField().getText();
    }

    public String getMaxValue() {
        return this.getMaxTextField().getText();
    }

    public void setMinValue(Number min) {
        this.getMinTextField().setText(min.toString());
    }

    public void setMaxValue(Number max) {
        this.getMaxTextField().setText(max.toString());
    }

    @Override
    public Optional<IConstraint> getConstraint() {
        Double min = null;
        Double max = null;
        try {
            min = Double.parseDouble(this.getMinValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            max = Double.parseDouble(this.getMaxValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        IConstraint constraint = null;
        if (min != null && max != null) {
            constraint = new MinMaxConstraint(this.getValueName(), min, max);
        } else if (min == null && max != null) {
            constraint = new MaxConstraint(this.getValueName(), max);
        } else if (min != null) {
            constraint = new MinConstraint(this.getValueName(), min);
        }
        return Optional.ofNullable(constraint);
    }
}

