/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui;

import com.guigarage.sdk.util.MaterialDesignButton;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import jfxtras.scene.control.LocalDateTimeTextField;
import vars.queryfx.StateLookup;
import vars.queryfx.ui.AbstractValuePanel;
import vars.queryfx.ui.db.DateBoundsConstraint;
import vars.queryfx.ui.db.IConstraint;

public class DateValuePanel
extends AbstractValuePanel {
    private LocalDateTimeTextField startControl;
    private LocalDateTimeTextField endControl;
    private ChangeListener<LocalDateTime> changeListener = (obs, oldVal, newVal) -> this.getConstrainCheckBox().setSelected(!oldVal.isEqual((ChronoLocalDateTime<?>)newVal));
    private Button scanButton = new MaterialDesignButton("Scan");

    public DateValuePanel(String valueName) {
        super(valueName);
        Region spacer = new Region();
        spacer.setMinWidth(20.0);
        HBox.setHgrow((Node)spacer, (Priority)Priority.NEVER);
        Region btnSpacer = new Region();
        btnSpacer.setMinWidth(10.0);
        HBox.setHgrow((Node)btnSpacer, (Priority)Priority.NEVER);
        this.getChildren().addAll((Object[])new Node[]{this.getStartControl(), spacer, this.getEndControl(), btnSpacer, this.scanButton});
        this.getConstrainCheckBox().setSelected(false);
    }

    private LocalDateTimeTextField getEndControl() {
        if (this.endControl == null) {
            LocalDateTime dt = LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS);
            this.endControl = new LocalDateTimeTextField(dt);
            this.endControl.parseErrorCallbackProperty().set(p -> {
                this.endControl.setLocalDateTime(dt);
                return null;
            });
            this.endControl.setDateTimeFormatter(DateTimeFormatter.ISO_DATE_TIME);
            this.endControl.setId("date-field");
            HBox.setHgrow((Node)this.endControl, (Priority)Priority.ALWAYS);
            this.endControl.localDateTimeProperty().addListener(this.changeListener);
        }
        return this.endControl;
    }

    private LocalDateTimeTextField getStartControl() {
        if (this.startControl == null) {
            LocalDateTime dt = StateLookup.getAnnotationStartDate().toLocalDateTime().truncatedTo(ChronoUnit.MINUTES);
            this.startControl = new LocalDateTimeTextField(dt);
            this.startControl.parseErrorCallbackProperty().set(p -> {
                this.startControl.setLocalDateTime(dt);
                return null;
            });
            this.startControl.setDateTimeFormatter(DateTimeFormatter.ISO_DATE_TIME);
            this.startControl.setId("date-field");
            HBox.setHgrow((Node)this.startControl, (Priority)Priority.ALWAYS);
            this.startControl.localDateTimeProperty().addListener(this.changeListener);
        }
        return this.startControl;
    }

    public ZonedDateTime getStartDate() {
        LocalDateTime local = this.getStartControl().getLocalDateTime();
        return ZonedDateTime.of(local, ZoneId.of("UTC"));
    }

    public ZonedDateTime getEndDate() {
        LocalDateTime local = this.getEndControl().getLocalDateTime();
        return ZonedDateTime.of(local, ZoneId.of("UTC"));
    }

    public void setStartDate(LocalDateTime local) {
        this.getStartControl().setLocalDateTime(local);
    }

    public void setEndDate(LocalDateTime local) {
        this.getEndControl().setLocalDateTime(local);
    }

    public void setOnScan(Runnable runnable) {
        this.scanButton.setOnAction(eh -> runnable.run());
    }

    @Override
    public Optional<IConstraint> getConstraint() {
        return Optional.of(new DateBoundsConstraint(this.getValueName(), new Date(this.getStartDate().toInstant().toEpochMilli()), new Date(this.getEndDate().toInstant().toEpochMilli())));
    }
}

