/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui;

import java.util.Collection;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import vars.ILink;

public class AssociationComboBoxListener
implements EventHandler<KeyEvent> {
    private final ComboBox<ILink> comboBox;
    private ObservableList<ILink> data;
    private boolean moveCaretToPos = false;
    private int caretPos;

    public AssociationComboBoxListener(ComboBox<ILink> comboBox) {
        this.comboBox = comboBox;
        this.data = comboBox.getItems();
        this.comboBox.setEditable(true);
        this.comboBox.setOnKeyPressed(e -> comboBox.hide());
        this.comboBox.setOnKeyReleased((EventHandler)this);
    }

    public void handle(KeyEvent event) {
        TextField editor = this.comboBox.getEditor();
        String text = editor.getText();
        if (event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.LEFT || event.isControlDown() || event.getCode() == KeyCode.HOME || event.getCode() == KeyCode.END || event.getCode() == KeyCode.TAB) {
            return;
        }
        if (event.getCode() == KeyCode.UP) {
            this.caretPos = -1;
            this.moveCaret(text.length());
            return;
        }
        if (event.getCode() == KeyCode.DOWN) {
            if (!this.comboBox.isShowing()) {
                this.comboBox.show();
            }
            this.caretPos = -1;
            this.moveCaret(text.length());
            return;
        }
        if (event.getCode() == KeyCode.BACK_SPACE) {
            this.moveCaretToPos = true;
            this.caretPos = editor.getCaretPosition();
        } else if (event.getCode() == KeyCode.DELETE) {
            this.moveCaretToPos = true;
            this.caretPos = editor.getCaretPosition();
        }
        String upperCaseText = text.toUpperCase();
        ObservableList list = FXCollections.observableArrayList((Collection)this.data.stream().filter(s -> s.getLinkName().toUpperCase().contains(upperCaseText) || s.getLinkValue().toUpperCase().contains(upperCaseText)).collect(Collectors.toList()));
        this.comboBox.setItems(list);
        this.comboBox.getEditor().setText(text);
        if (!this.moveCaretToPos) {
            this.caretPos = -1;
        }
        this.moveCaret(text.length());
        if (!list.isEmpty()) {
            this.comboBox.show();
        }
    }

    private void moveCaret(int textLength) {
        if (this.caretPos == -1) {
            this.comboBox.getEditor().positionCaret(textLength);
        } else {
            this.comboBox.getEditor().positionCaret(this.caretPos);
        }
        this.moveCaretToPos = false;
    }
}

