/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import com.guigarage.sdk.Application;
import com.guigarage.sdk.action.Action;
import com.guigarage.sdk.util.FontBasedIcon;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.paint.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.queryfx.StateLookup;
import vars.queryfx.ToolBelt;
import vars.queryfx.beans.QueryParams;
import vars.queryfx.beans.ResolvedConceptSelection;
import vars.queryfx.beans.ResultsCustomization;
import vars.queryfx.rx.messages.ExecuteSearchMsg;
import vars.queryfx.rx.messages.NewResolvedConceptSelectionMsg;
import vars.queryfx.rx.messages.ShowAdvancedSearchWorkbenchMsg;
import vars.queryfx.rx.messages.ShowBasicSearchWorkbenchMsg;
import vars.queryfx.rx.messages.ShowConceptConstraintsWorkbenchMsg;
import vars.queryfx.rx.messages.ShowCustomizeResultsWorkbenchMsg;
import vars.queryfx.ui.AppIcons;
import vars.queryfx.ui.controllers.AppController;
import vars.queryfx.ui.controllers.SaveResultsController;
import vars.queryfx.ui.db.ConceptConstraint;
import vars.queryfx.ui.sdkfx.AdvancedSearchWorkbench;
import vars.queryfx.ui.sdkfx.BasicSearchWorkbench;
import vars.queryfx.ui.sdkfx.ConceptConstraintsWorkbench;
import vars.queryfx.ui.sdkfx.ConceptMedia;
import vars.queryfx.ui.sdkfx.CustomizeResultsWorkbench;
import vars.shared.javafx.application.ImageFX;
import vars.shared.rx.RXEventBus;
import vars.shared.rx.messages.AbstractExceptionMsg;
import vars.shared.ui.GlobalStateLookup;

public class App {
    public static final Date MIN_RECORDED_DATE = new Date(378720000000L);
    private RXEventBus eventBus = new RXEventBus();
    private static Logger log;
    private final ToolBelt toolBelt;
    private Application application;
    private final AppController appController;
    private final SaveResultsController saveResultsController;
    private BasicSearchWorkbench basicSearchWorkbench;
    private ConceptConstraintsWorkbench conceptConstraintsWorkbench;
    private CustomizeResultsWorkbench customizeResultsWorkbench;
    private AdvancedSearchWorkbench advancedSearchWorkbench;

    public App(ToolBelt toolBelt) {
        Preconditions.checkArgument((toolBelt != null ? 1 : 0) != 0);
        this.appController = new AppController(toolBelt.getQueryService(), this.eventBus, toolBelt.getExecutor());
        this.saveResultsController = new SaveResultsController(this.eventBus, toolBelt.getExecutor());
        this.toolBelt = toolBelt;
        this.eventBus.toObserverable().ofType(NewResolvedConceptSelectionMsg.class).subscribe(msg -> this.addResolvedConceptSelection(msg.getResolvedConceptSelection()));
        this.eventBus.toObserverable().ofType(AbstractExceptionMsg.class).subscribe(msg -> log.error(msg.getMessage(), msg.getException()));
        this.eventBus.toObserverable().ofType(ShowAdvancedSearchWorkbenchMsg.class).subscribe(msg -> this.showAdvancedSearch(this.getApplication()));
        this.eventBus.toObserverable().ofType(ShowBasicSearchWorkbenchMsg.class).subscribe(msg -> this.showBasicSearch(this.getApplication()));
        this.eventBus.toObserverable().ofType(ShowConceptConstraintsWorkbenchMsg.class).subscribe(msg -> this.showConceptConstraintsWorkBench(this.getApplication()));
        this.eventBus.toObserverable().ofType(ShowCustomizeResultsWorkbenchMsg.class).subscribe(msg -> this.showCustomizeResults(this.getApplication()));
    }

    protected Application getApplication() {
        if (this.application == null) {
            this.application = new Application();
            this.application.addStylesheet(this.getClass().getResource("/vars/queryfx/queryfx.css").toExternalForm());
            this.application.setTitle("VARS Query");
            this.application.addToolbarItem(new Action((FontBasedIcon)AppIcons.HOME, "Home", () -> this.eventBus.send((Object)new ShowBasicSearchWorkbenchMsg())));
            this.application.setBaseColor(new Color(0.10588235294117647, 0.30196078431372547, 0.5764705882352941, 1.0));
            this.application.addMenuEntry(new Action((FontBasedIcon)AppIcons.HOME, "Home", () -> this.eventBus.send((Object)new ShowBasicSearchWorkbenchMsg())));
            this.application.addMenuEntry(new Action((FontBasedIcon)AppIcons.SEARCH_PLUS, "Refine Search", () -> this.eventBus.send((Object)new ShowAdvancedSearchWorkbenchMsg())));
            this.application.addMenuEntry(new Action((FontBasedIcon)AppIcons.GEARS, "Customize Results", () -> this.eventBus.send((Object)new ShowCustomizeResultsWorkbenchMsg())));
            this.showBasicSearch(this.application);
            this.getAdvancedSearchWorkbench();
        }
        return this.application;
    }

    protected void doSearch() {
        List<ConceptConstraint> conceptConstraints = this.getBasicSearchWorkbench().getConceptSelections().stream().map(ConceptConstraint::new).collect(Collectors.toList());
        QueryParams queryParams = this.getAdvancedSearchWorkbench().getQueryParams();
        if (conceptConstraints.isEmpty() && queryParams.getQueryConstraints().isEmpty()) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("Whoops!");
            alert.setHeaderText("Unable to complete search");
            alert.setContentText("You did not specify any search constraints, so you are asking for the entire database. That's not allowed");
            alert.showAndWait();
        } else {
            ResultsCustomization resultsCustomization = this.getCustomizeResultsWorkbench().getResultsCustomization();
            ExecuteSearchMsg msg = new ExecuteSearchMsg(conceptConstraints, queryParams.getQueryReturns(), queryParams.getQueryConstraints(), resultsCustomization);
            this.eventBus.send((Object)msg);
        }
    }

    protected void showBasicSearch(Application app) {
        BasicSearchWorkbench view = this.getBasicSearchWorkbench();
        app.setWorkbench((Node)view);
        app.clearGlobalActions();
        app.addGlobalAction(new Action((FontBasedIcon)AppIcons.SEARCH, this::doSearch));
    }

    protected void showAdvancedSearch(Application app) {
        app.clearGlobalActions();
        AdvancedSearchWorkbench view = this.getAdvancedSearchWorkbench();
        app.setWorkbench((Node)view);
    }

    protected void showConceptConstraintsWorkBench(Application app) {
        app.clearGlobalActions();
        ConceptConstraintsWorkbench view = this.getConceptConstraintsWorkbench(app);
        app.setWorkbench((Node)view);
    }

    protected void showCustomizeResults(Application app) {
        app.clearGlobalActions();
        CustomizeResultsWorkbench view = this.getCustomizeResultsWorkbench();
        app.setWorkbench((Node)view);
    }

    protected BasicSearchWorkbench getBasicSearchWorkbench() {
        if (this.basicSearchWorkbench == null) {
            this.basicSearchWorkbench = new BasicSearchWorkbench(this.eventBus);
        }
        return this.basicSearchWorkbench;
    }

    protected ConceptConstraintsWorkbench getConceptConstraintsWorkbench(Application app) {
        if (this.conceptConstraintsWorkbench == null) {
            this.conceptConstraintsWorkbench = new ConceptConstraintsWorkbench(this.toolBelt.getQueryService(), this.toolBelt.getExecutor(), this.eventBus);
        }
        return this.conceptConstraintsWorkbench;
    }

    protected CustomizeResultsWorkbench getCustomizeResultsWorkbench() {
        if (this.customizeResultsWorkbench == null) {
            this.customizeResultsWorkbench = new CustomizeResultsWorkbench();
        }
        return this.customizeResultsWorkbench;
    }

    protected AdvancedSearchWorkbench getAdvancedSearchWorkbench() {
        if (this.advancedSearchWorkbench == null) {
            this.advancedSearchWorkbench = new AdvancedSearchWorkbench(this.toolBelt.getQueryService(), this.eventBus);
        }
        return this.advancedSearchWorkbench;
    }

    private void addResolvedConceptSelection(ResolvedConceptSelection rcs) {
        Platform.runLater(() -> {
            BasicSearchWorkbench bsw = this.getBasicSearchWorkbench();
            ConceptMedia conceptMedia = new ConceptMedia(rcs);
            bsw.getConceptMedia().add((Object)conceptMedia);
        });
    }

    private static Logger getLog() {
        if (log == null) {
            log = LoggerFactory.getLogger(App.class);
        }
        return log;
    }

    public static void main(String[] args) {
        System.setProperty("user.timezone", "UTC");
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        GlobalStateLookup.getSettingsDirectory();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable e) {
                Logger log = LoggerFactory.getLogger(thread.getClass());
                log.error("Exception in thread [" + thread.getName() + "]", e);
            }
        });
        Logger mainLog = App.getLog();
        if (mainLog.isInfoEnabled()) {
            Date date = new Date();
            mainLog.info("This application was launched at " + date.toString());
        }
        Injector injector = StateLookup.getInjector();
        ToolBelt toolBelt = (ToolBelt)injector.getInstance(ToolBelt.class);
        try {
            Connection connection = toolBelt.getQueryService().getAnnotationConnection();
            connection.close();
        }
        catch (SQLException e) {
            App.getLog().error("Failed to connect to annotation database", (Throwable)e);
        }
        App app = new App(toolBelt);
        StateLookup.setApp(app);
        ImageFX.setIsJavaFXRunning((boolean)true);
        app.getApplication().setPrefSize(800.0, 900.0);
        app.getApplication().setStopCallback(() -> System.exit(0));
        app.getApplication().show();
    }
}

