/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.ui;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import vars.queryfx.ui.db.IConstraint;

public abstract class AbstractValuePanel
extends HBox {
    private static final Pattern PATTERN = Pattern.compile("\\B[A-Z]+");
    private CheckBox constrainCheckBox;
    private CheckBox returnCheckBox;
    private final String valueName;
    private String title;

    public AbstractValuePanel(String valueName) {
        this.valueName = valueName;
        this.constrainCheckBox = new CheckBox();
        this.constrainCheckBox.setTooltip(new Tooltip("constrain"));
        this.returnCheckBox = new CheckBox();
        this.returnCheckBox.setTooltip(new Tooltip("return"));
        this.getChildren().addAll((Object[])new Node[]{this.returnCheckBox, this.constrainCheckBox});
    }

    public boolean isReturned() {
        return this.returnCheckBox.isSelected();
    }

    public void setReturned(boolean returned) {
        this.returnCheckBox.setSelected(returned);
    }

    public boolean isConstrained() {
        return this.constrainCheckBox.isSelected();
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = this.valueName;
            if (!this.valueName.toUpperCase().equals(this.valueName)) {
                Matcher matcher = PATTERN.matcher(this.valueName);
                this.title = matcher.replaceAll(" $0");
            }
        }
        return this.title;
    }

    public String getValueName() {
        return this.valueName;
    }

    protected CheckBox getConstrainCheckBox() {
        return this.constrainCheckBox;
    }

    protected CheckBox getReturnCheckBox() {
        return this.returnCheckBox;
    }

    public abstract Optional<IConstraint> getConstraint();
}

