/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx.config;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource {
    private final Config config;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Resource(String resource) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"Resource argument can not be null");
        this.config = ConfigFactory.load((String)resource);
    }

    public Resource(Config config) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"Config argument can not be null");
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public Optional<String> findByKey(String key) {
        Optional<String> value = Optional.empty();
        try {
            value = Optional.ofNullable(this.config.getString(key));
        }
        catch (Exception e) {
            this.log.debug("Failed to lookup '" + key + "'", (Throwable)e);
        }
        return value;
    }
}

