/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx;

import com.google.common.base.Preconditions;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import vars.ILink;
import vars.LinkBean;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.SimpleConceptBean;
import vars.knowledgebase.SimpleConceptNameBean;
import vars.queryfx.QueryModule;
import vars.queryfx.ui.App;
import vars.shared.ui.GlobalStateLookup;

public class StateLookup
extends GlobalStateLookup {
    private static final String appConfig = "vars/queryfx/app";
    private static Injector injector;
    private static final Config config;
    private static App app;
    public static final String WILD_CARD = "*";
    public static final Concept WILD_CARD_CONCEPT;
    public static final ILink WILD_CARD_LINK;
    private static final Object lockObject;

    public static Config getConfig() {
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Injector getInjector() {
        if (injector == null) {
            Object object = lockObject;
            synchronized (object) {
                injector = Guice.createInjector((Module[])new Module[]{new QueryModule()});
            }
        }
        return injector;
    }

    public static ZonedDateTime getAnnotationStartDate() {
        Config config = StateLookup.getConfig();
        String startDate = config.getString("vars.annotation.start.date");
        return ZonedDateTime.ofInstant(Instant.parse(startDate), ZoneId.of("UTC"));
    }

    public static App getApp() {
        return app;
    }

    public static void setApp(App app) {
        Preconditions.checkArgument((app != null ? 1 : 0) != 0);
        StateLookup.app = app;
    }

    static {
        config = ConfigFactory.load((String)appConfig);
        WILD_CARD_CONCEPT = new SimpleConceptBean(new SimpleConceptNameBean(WILD_CARD, ConceptNameTypes.PRIMARY.getName()));
        WILD_CARD_LINK = new LinkBean(WILD_CARD, WILD_CARD, WILD_CARD);
        lockObject = new Object();
    }
}

