/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx;

import com.google.inject.Binder;
import com.google.inject.Module;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.util.BuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.jpa.VarsJpaModule;
import vars.queryfx.AsyncQueryService;
import vars.queryfx.AsyncQueryServiceImpl;
import vars.queryfx.StateLookup;
import vars.queryfx.config.Resource;

public class QueryModule
implements Module {
    public final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String annotationPersistenceUnit;
    private final String knowledgebasePersistenceUnit;
    private final String miscPersistenceUnit;

    public QueryModule() {
        Resource resource = new Resource(StateLookup.getConfig());
        this.log.info(resource.getConfig().toString());
        this.annotationPersistenceUnit = resource.findByKey("vars.annotation.persistence.unit").get();
        this.knowledgebasePersistenceUnit = resource.findByKey("vars.knowledgebase.persistence.unit").get();
        this.miscPersistenceUnit = resource.findByKey("vars.misc.persistence.unit").get();
    }

    public void configure(Binder binder) {
        binder.install((Module)new VarsJpaModule(this.annotationPersistenceUnit, this.knowledgebasePersistenceUnit, this.miscPersistenceUnit));
        binder.bind(BuilderFactory.class).to(JavaFXBuilderFactory.class);
        binder.bind(AsyncQueryService.class).to(AsyncQueryServiceImpl.class).asEagerSingleton();
        ExecutorService executor = Executors.newCachedThreadPool();
        binder.bind(Executor.class).toInstance((Object)executor);
    }
}

