/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx;

import com.google.common.base.Preconditions;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import vars.ILink;
import vars.LinkBean;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.SimpleConceptBean;
import vars.knowledgebase.SimpleConceptNameBean;
import vars.queryfx.QueryModule;
import vars.queryfx.ui.App;
import vars.shared.ui.GlobalLookup;

public class Lookup
extends GlobalLookup {
    private static final String appConfig = "vars/queryfx/app";
    public static final String WILD_CARD = "*";
    public static final Concept WILD_CARD_CONCEPT = new SimpleConceptBean(new SimpleConceptNameBean("*", ConceptNameTypes.PRIMARY.getName()));
    public static final ILink WILD_CARD_LINK = new LinkBean("*", "*", "*");
    private static Injector injector;
    private static App app;
    private static Config config;
    private static final Object injectorLock;
    private static final Object configLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Injector getInjector() {
        Object object = injectorLock;
        synchronized (object) {
            if (injector == null) {
                injector = Guice.createInjector((Module[])new Module[]{new QueryModule()});
            }
        }
        return injector;
    }

    public static App getApp() {
        return app;
    }

    public static void setApp(App app) {
        Preconditions.checkArgument((app != null ? 1 : 0) != 0);
        Lookup.app = app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Config getConfig() {
        Object object = configLock;
        synchronized (object) {
            if (config == null) {
                config = ConfigFactory.load((String)appConfig);
            }
        }
        return config;
    }

    public static ZonedDateTime getAnnotationStartDate() {
        Config config = Lookup.getConfig();
        String startDate = config.getString("vars.annotation.start.date");
        return ZonedDateTime.ofInstant(Instant.parse(startDate), ZoneId.of("UTC"));
    }

    static {
        config = ConfigFactory.load((String)appConfig);
        injectorLock = new Object(){};
        configLock = new Object(){};
    }
}

