/*
 * Decompiled with CFR 0.152.
 */
package vars.queryfx;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mbari.sql.QueryResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ILink;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.knowledgebase.Media;
import vars.query.QueryPersistenceService;
import vars.queryfx.AsyncQueryService;
import vars.queryfx.beans.ConceptSelection;
import vars.queryfx.beans.ResolvedConceptSelection;

public class AsyncQueryServiceImpl
implements AsyncQueryService {
    private final Executor executor;
    private final QueryPersistenceService queryPersistenceService;
    private final KnowledgebaseDAOFactory knowledgebaseDAOFactory;
    private final Function<Concept, Collection<String>> asNames = c -> c.getConceptNames().stream().map(ConceptName::getName).collect(Collectors.toList());
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Inject
    public AsyncQueryServiceImpl(Executor executor, KnowledgebaseDAOFactory knowledgebaseDAOFactory, QueryPersistenceService queryPersistenceService) {
        this.executor = executor;
        this.knowledgebaseDAOFactory = knowledgebaseDAOFactory;
        this.queryPersistenceService = queryPersistenceService;
    }

    @Override
    public CompletableFuture<List<String>> findAllConceptNamesAsStrings() {
        return CompletableFuture.supplyAsync(this.queryPersistenceService::findAllConceptNamesAsStrings, this.executor);
    }

    @Override
    public CompletableFuture<List<String>> findDescendantNamesAsStrings(String conceptName) {
        return CompletableFuture.supplyAsync(() -> this.queryPersistenceService.findDescendantNamesAsStrings(conceptName), this.executor);
    }

    @Override
    public CompletableFuture<Optional<Concept>> findConcept(String name) {
        return CompletableFuture.supplyAsync(() -> Optional.ofNullable(this.knowledgebaseDAOFactory.newConceptDAO().findByName(name)), this.executor);
    }

    public CompletableFuture<Collection<Concept>> findConcepts(String name, boolean extendToParent, boolean extendToSiblings, boolean extendToChildren, boolean extendToDescendants) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"You must supply a concept name");
        return CompletableFuture.supplyAsync(() -> this.queryPersistenceService.findConcepts(name, extendToParent, extendToSiblings, extendToChildren, extendToDescendants), this.executor);
    }

    @Override
    public CompletableFuture<List<String>> findConceptNamesAsStrings(String name, boolean extendToParent, boolean extendToSiblings, boolean extendToChildren, boolean extendToDescendants) {
        return this.findConcepts(name, extendToParent, extendToSiblings, extendToChildren, extendToDescendants).handleAsync((cs, t) -> {
            List<Object> names = cs != null ? cs.stream().flatMap(c -> this.asNames.apply((Concept)c).stream()).sorted().collect(Collectors.toList()) : new ArrayList();
            return names;
        }, this.executor);
    }

    @Override
    public CompletableFuture<List<ILink>> findAllLinks() {
        return CompletableFuture.supplyAsync(() -> new ArrayList<ILink>(this.queryPersistenceService.findAllLinkTemplates()), this.executor);
    }

    @Override
    public CompletableFuture<List<ILink>> findLinksByConceptNames(Collection<String> conceptNames) {
        return CompletableFuture.supplyAsync(() -> new ArrayList<ILink>(this.queryPersistenceService.findLinksByConceptNames(conceptNames)), this.executor);
    }

    @Override
    public CompletableFuture<Optional<URL>> resolveImageURL(String conceptName) {
        return this.findConcept(conceptName).thenApplyAsync(co -> co.flatMap(c -> {
            Media primaryImage = c.getConceptMetadata().getPrimaryImage();
            Optional<Object> url = Optional.empty();
            if (primaryImage != null) {
                try {
                    url = Optional.of(new URL(primaryImage.getUrl()));
                }
                catch (MalformedURLException e) {
                    this.log.info("Invalid URL for '" + conceptName + "': " + primaryImage.getUrl());
                }
            }
            return url;
        }), this.executor);
    }

    @Override
    public CompletableFuture<Map<String, String>> getAnnotationViewMetadata() {
        return CompletableFuture.supplyAsync(this.queryPersistenceService::getMetaData, this.executor);
    }

    @Override
    public CompletableFuture<Collection<?>> getAnnotationViewsUniqueValuesForColumn(String columnName) {
        return CompletableFuture.supplyAsync(() -> this.queryPersistenceService.getUniqueValuesByColumn(columnName), this.executor);
    }

    @Override
    public CompletableFuture<List<Number>> getAnnotationViewsMinAndMaxForColumn(String columnName) {
        String sql = "SELECT MIN(" + columnName + ") AS minValue, MAX(" + columnName + ") AS maxValue FROM Annotations WHERE " + columnName + " IS NOT NULL";
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Number> minMax = new ArrayList<Number>();
            try {
                QueryResults queryResults = this.queryPersistenceService.executeQuery(sql);
                minMax.add((Number)queryResults.getResults("minValue").get(0));
                minMax.add((Number)queryResults.getResults("maxValue").get(0));
            }
            catch (Exception e) {
                this.log.error("An error occurred while executing the SQL statement: '" + sql + "'", (Throwable)e);
            }
            return minMax;
        }, this.executor);
    }

    @Override
    public CompletableFuture<List<Date>> getAnnotationViewsMinAndMaxDatesforColumn(String columnName) {
        String sql = "SELECT MIN(" + columnName + ") AS minValue, MAX(" + columnName + ") AS maxValue FROM Annotations WHERE " + columnName + " IS NOT NULL";
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Date> minMax = new ArrayList<Date>();
            try {
                QueryResults queryResults = this.queryPersistenceService.executeQuery(sql);
                minMax.add((Date)queryResults.getResults("minValue").get(0));
                minMax.add((Date)queryResults.getResults("maxValue").get(0));
            }
            catch (Exception e) {
                this.log.error("An error occurred while executing the SQL statement: '" + sql + "'", (Throwable)e);
            }
            return minMax;
        }, this.executor);
    }

    @Override
    public Connection getAnnotationConnection() throws SQLException {
        return this.queryPersistenceService.getAnnotationQueryable().getConnection();
    }

    @Override
    public CompletableFuture<List<Concept>> findAncestors(String conceptName) {
        return CompletableFuture.supplyAsync(() -> this.queryPersistenceService.findAncestors(conceptName), this.executor);
    }

    @Override
    public CompletableFuture<ResolvedConceptSelection> resolveConceptSelection(ConceptSelection conceptSelection) {
        return this.findConceptNamesAsStrings(conceptSelection.getConceptName(), conceptSelection.isExtendToParent(), conceptSelection.isExtendToSiblings(), conceptSelection.isExtendToChildren(), conceptSelection.isExtendToDescendants()).thenApplyAsync(list -> new ResolvedConceptSelection(conceptSelection, (List<String>)list), this.executor);
    }
}

