/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.udp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.Optional;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.time.Timecode;
import org.mbari.vcr4j.udp.UDPError;
import org.mbari.vcr4j.udp.UDPResponseParser;
import org.mbari.vcr4j.udp.UDPState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class UDPVideoIO
implements VideoIO<UDPState, UDPError> {
    private final int port;
    private final InetAddress inetAddress;
    private final DatagramPacket incomingPacket;
    private final DatagramPacket requestTimecodePacket;
    private DatagramSocket socket;
    private byte[] receiveMessage = new byte[1024];
    public static final byte[] GET_TIMECODE = "ltc.".getBytes();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Optional<VideoCommand> timecodeRequest = Optional.of(VideoCommands.REQUEST_TIMECODE);
    UDPResponseParser responseParser = new UDPResponseParser();
    private final Subject<UDPState, UDPState> stateSubject = new SerializedSubject((Subject)PublishSubject.create());
    private final Observable<VideoIndex> indexObservable = this.responseParser.getTimecodeObservable().map(tc -> new VideoIndex(Optional.of(Instant.now()), Optional.empty(), Optional.of(tc)));
    private final Subject<VideoCommand, VideoCommand> commandSubject = new SerializedSubject((Subject)PublishSubject.create());

    public UDPVideoIO(String host, int port) throws UnknownHostException, SocketException {
        this.port = port;
        this.inetAddress = InetAddress.getByName(host);
        this.incomingPacket = new DatagramPacket(this.receiveMessage, this.receiveMessage.length);
        this.requestTimecodePacket = new DatagramPacket(GET_TIMECODE, GET_TIMECODE.length, this.inetAddress, port);
        this.commandSubject.filter(vc -> vc.equals(VideoCommands.REQUEST_TIMECODE) || vc.equals(VideoCommands.REQUEST_INDEX)).subscribe(vc -> this.sendCommand(this.requestTimecodePacket));
        this.commandSubject.filter(vc -> vc.equals(VideoCommands.REQUEST_STATUS)).subscribe(vc -> {
            UDPState state = this.socket != null && !this.socket.isClosed() ? UDPState.RECORDING : UDPState.STOPPED;
            this.stateSubject.onNext((Object)state);
        });
    }

    private synchronized void sendCommand(DatagramPacket packet) {
        block2: {
            try {
                DatagramSocket s = this.getSocket();
                s.send(packet);
                s.receive(this.incomingPacket);
                int numBytes = this.incomingPacket.getLength();
                byte[] response = new byte[numBytes];
                System.arraycopy(this.incomingPacket.getData(), 0, response, 0, numBytes);
                this.responseParser.update(response, this.timecodeRequest);
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block2;
                this.log.error("UDP connection failed.", (Throwable)e);
                this.responseParser.getErrorObservable().onNext((Object)new UDPError(true, false, this.timecodeRequest));
            }
        }
    }

    public void close() {
        if (this.socket != null && !this.socket.isClosed()) {
            this.log.info("Closing UDP port: " + this.getConnectionID());
            this.socket.close();
        }
        this.stateSubject.onNext((Object)UDPState.STOPPED);
        this.commandSubject.onCompleted();
        this.stateSubject.onCompleted();
        this.responseParser.getErrorObservable().onCompleted();
        this.responseParser.getTimecodeObservable().onCompleted();
    }

    public <A extends VideoCommand> void send(A videoCommand) {
        this.commandSubject.onNext(videoCommand);
    }

    public Subject<VideoCommand, VideoCommand> getCommandSubject() {
        return this.commandSubject;
    }

    public String getConnectionID() {
        String connectionName = "Not connected";
        try {
            DatagramSocket s = this.getSocket();
            connectionName = s.getInetAddress().getHostName() + ":" + s.getPort();
        }
        catch (SocketException ex) {
            this.log.error("Failed to open a DatagramSocket", (Throwable)ex);
            this.responseParser.getErrorObservable().onNext((Object)new UDPError(true, false, Optional.empty()));
        }
        return connectionName;
    }

    private DatagramSocket getSocket() throws SocketException {
        if (this.socket == null || this.socket.isClosed() || !this.socket.isConnected()) {
            this.socket = new DatagramSocket(0);
            this.socket.connect(this.inetAddress, this.port);
            this.socket.setSoTimeout(4000);
        }
        return this.socket;
    }

    protected void finalize() throws Throwable {
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
        super.finalize();
    }

    public Observable<UDPError> getErrorObservable() {
        return this.responseParser.getErrorObservable();
    }

    public Observable<UDPState> getStateObservable() {
        return this.stateSubject;
    }

    public Observable<VideoIndex> getIndexObservable() {
        return this.indexObservable;
    }

    public Observable<Timecode> getTimecodeObservable() {
        return this.responseParser.getTimecodeObservable();
    }

    public InetAddress getInetAddress() {
        return this.requestTimecodePacket.getAddress();
    }

    public int getPort() {
        return this.requestTimecodePacket.getPort();
    }
}

