/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.udp;

import org.mbari.vcr4j.VideoState;

public class UDPState
implements VideoState {
    private final boolean connected;
    private final boolean playing;
    private final boolean recording;
    public static final UDPState STOPPED = new UDPState(false, false, false);
    public static final UDPState RECORDING = new UDPState(true, false, true);

    public UDPState(boolean connected, boolean playing, boolean recording) {
        this.connected = connected;
        this.playing = playing;
        this.recording = recording;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isCueingUp() {
        return false;
    }

    public boolean isFastForwarding() {
        return false;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public boolean isReverseDirection() {
        return false;
    }

    public boolean isRewinding() {
        return false;
    }

    public boolean isShuttling() {
        return false;
    }

    public boolean isStopped() {
        return !this.playing && !this.recording;
    }

    public boolean isRecording() {
        return this.recording;
    }
}

