/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.udp;

import java.io.UnsupportedEncodingException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.time.Timecode;
import org.mbari.vcr4j.udp.UDPError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class UDPResponseParser {
    private final Subject<UDPError, UDPError> errorObservable = new SerializedSubject((Subject)PublishSubject.create());
    private final Subject<Timecode, Timecode> timecodeObservable = new SerializedSubject((Subject)PublishSubject.create());
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Pattern pattern = Pattern.compile("[0-2][0-9]:[0-5][0-9]:[0-5][0-9]:[0-2][0-9]");

    public void update(byte[] response, Optional<VideoCommand> videoCommand) {
        videoCommand.ifPresent(vc -> {
            block3: {
                block2: {
                    if (vc.equals(VideoCommands.REQUEST_TIMECODE)) break block2;
                    if (!vc.equals(VideoCommands.REQUEST_TIMESTAMP)) break block3;
                }
                this.responseToTimecode(response, videoCommand).ifPresent(arg_0 -> this.timecodeObservable.onNext(arg_0));
            }
        });
    }

    public Subject<UDPError, UDPError> getErrorObservable() {
        return this.errorObservable;
    }

    public Subject<Timecode, Timecode> getTimecodeObservable() {
        return this.timecodeObservable;
    }

    private Optional<Timecode> responseToTimecode(byte[] response, Optional<VideoCommand> videoCommand) {
        Optional<Timecode> timecode;
        block11: {
            String result;
            block10: {
                result = null;
                try {
                    result = new String(response, "ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    try {
                        result = new String(response, "8859_1");
                    }
                    catch (UnsupportedEncodingException ex) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error("Timecode over UDP is using an unknown encoding");
                            this.errorObservable.onNext((Object)new UDPError(false, true, videoCommand));
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block10;
                    this.errorObservable.onNext((Object)new UDPError(false, true, videoCommand));
                }
            }
            timecode = Optional.empty();
            if (result != null) {
                try {
                    Matcher matcher = pattern.matcher(result);
                    if (matcher.find()) {
                        timecode = Optional.of(new Timecode(matcher.group(0)));
                    }
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block11;
                    this.log.error("Problem with parsing timecode '" + result + "'", (Throwable)e);
                    this.errorObservable.onNext((Object)new UDPError(false, true, videoCommand));
                }
            }
        }
        return timecode;
    }
}

