/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.time.Instant;
import java.util.GregorianCalendar;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeServer {
    private final DatagramSocket socket;
    private final AtomicBoolean run = new AtomicBoolean(false);
    private volatile Thread serverThread;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public TimeServer(int port) throws SocketException {
        this.socket = new DatagramSocket(port);
    }

    public void start() {
        if (!this.run.get()) {
            this.log.debug("Starting time server");
            this.run.set(true);
            Runnable runner = () -> {
                byte[] buffer = new byte[4096];
                while (this.run.get()) {
                    DatagramPacket incoming = new DatagramPacket(buffer, buffer.length);
                    try {
                        this.socket.receive(incoming);
                        GregorianCalendar calendar = new GregorianCalendar();
                        double frames = (double)calendar.get(14) / 1000.0 * 29.97;
                        String reply = String.format("%tT:%02d", calendar, Math.round(frames));
                        DatagramPacket outgoing = new DatagramPacket(reply.getBytes(), reply.length(), incoming.getAddress(), incoming.getPort());
                        this.socket.send(outgoing);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            this.serverThread = new Thread(runner, this.getClass().getSimpleName() + "-" + Instant.now());
            this.serverThread.start();
        }
    }

    public void stop() {
        this.log.debug("Stopping time server");
        this.run.set(false);
        this.serverThread = null;
    }

    public static void main(String[] args) throws Exception {
        int port = 9000;
        if (args.length > 0) {
            port = Integer.valueOf(args[0]);
        }
        TimeServer server = new TimeServer(port);
        server.start();
    }
}

