/*
 * Decompiled with CFR 0.152.
 */
package vars.avfoundation;

import java.awt.Frame;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import org.bushe.swing.event.EventBus;
import org.mbari.nativelib.Native;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.VARSException;
import vars.avfoundation.AVFImageCaptureDialog;
import vars.avplayer.ImageCaptureException;
import vars.avplayer.ImageCaptureService;
import vars.shared.ui.GlobalStateLookup;
import vars.shared.ui.dialogs.StandardDialog;

public class AVFImageCaptureServiceImpl
implements ImageCaptureService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String LIBRARY_NAME = "avfimagesnap";
    private volatile boolean isStarted = false;
    private StandardDialog dialog;
    File tempDir = new File(System.getProperty("java.io.tmpdir"));

    public AVFImageCaptureServiceImpl() {
        try {
            System.loadLibrary(LIBRARY_NAME);
            this.log.info("avfimagesnap was found on the java.library.path and loaded");
        }
        catch (UnsatisfiedLinkError e) {
            this.extractAndLoadNativeLibraries();
        }
        this.videoDevicesAsStrings();
    }

    public native String[] videoDevicesAsStrings();

    public native String startSessionWithNamedDevice(String var1);

    public native String saveSnapshotToSpecifiedPath(String var1);

    public native void stopSession();

    public Optional<Image> capture(File file) throws ImageCaptureException {
        if (!this.isStarted) {
            this.startDevice();
        }
        this.saveSnapshotToSpecifiedPath(file.getAbsolutePath());
        BufferedImage image = null;
        try {
            image = this.watchForAndReadNewImage(file);
        }
        catch (Exception e) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)e);
        }
        return Optional.ofNullable(image);
    }

    public void dispose() {
    }

    public void showSettingsDialog() {
        Preferences preferences = Preferences.userRoot();
        String originalVideoSrc = preferences.get(LIBRARY_NAME, "");
        if (this.dialog == null) {
            Frame frame = GlobalStateLookup.getSelectedFrame();
            String[] devices = this.videoDevicesAsStrings();
            this.dialog = new AVFImageCaptureDialog(frame, devices);
        }
        this.dialog.setVisible(true);
        String newVideoSrc = preferences.get(LIBRARY_NAME, "");
        if (!newVideoSrc.equals(originalVideoSrc)) {
            this.stopDevice();
            this.startDevice();
        }
    }

    private void startDevice() {
        Preferences preferences = Preferences.userRoot();
        String videoSource = preferences.get(LIBRARY_NAME, "");
        if (this.isStarted) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("The video device '" + videoSource + "' is already opened"));
        } else if (!videoSource.isEmpty()) {
            this.log.debug("Starting image capture service, {}, using {}", (Object)this.getClass().getName(), (Object)videoSource);
            this.startSessionWithNamedDevice(videoSource);
            this.isStarted = true;
        } else {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"A video source has not been selected");
        }
    }

    private void stopDevice() {
        this.log.debug("Stopping image capture service, {}", (Object)this.getClass().getName());
        this.stopSession();
        this.isStarted = false;
    }

    private void extractAndLoadNativeLibraries() {
        String libraryName = System.mapLibraryName(LIBRARY_NAME);
        String os = System.getProperty("os.name");
        if (libraryName != null) {
            File libraryHome = new File(new File(GlobalStateLookup.getSettingsDirectory(), "native"), os.substring(0, 3));
            if (!libraryHome.exists()) {
                libraryHome.mkdirs();
            }
            if (!libraryHome.canWrite()) {
                throw new VARSException("Unable to extract native 'avfimagesnap' library to " + libraryHome + ". Verify that you have write access to that directory");
            }
            new Native(LIBRARY_NAME, "native", libraryHome, this.getClass().getClassLoader());
        } else {
            this.log.error("A native 'avfimagesnap' library for your platform is not available. You will not be able to use AVFoundation to capture images");
        }
    }

    private BufferedImage watchForAndReadNewImage(File file) throws IOException, InterruptedException {
        BufferedImage image = null;
        long timeoutNanos = 3000000000L;
        long elapsedNanos = 0L;
        long startNanos = System.nanoTime();
        while (elapsedNanos < timeoutNanos && !file.exists()) {
            Thread.sleep(50L);
            elapsedNanos = System.nanoTime() - startNanos;
        }
        if (file.exists()) {
            image = ImageIO.read(file);
        }
        return image;
    }
}

