/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.util;

import com.guigarage.sdk.util.BindableTransition;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class SliderPane
extends Region {
    private ObjectProperty<Node> content;
    private ObjectProperty<Node> popover;
    private Pane contentWrapper;
    private Pane popoverWrapper;
    private ParallelTransition mouseExitTransition;
    private ParallelTransition mouseEnteredTransition;
    private DoubleProperty popupVisiblePercents;
    private double slideInDuration = 0.4;
    private double slideOutDuration = 0.4;
    private BooleanProperty pinned;
    private BooleanProperty popoverVisible;
    private Region contentClassPane;

    public SliderPane() {
        this.setMaxHeight(Double.MAX_VALUE);
        this.getStyleClass().add((Object)"slider-pane");
        Rectangle clipRect = new Rectangle();
        clipRect.setX(0.0);
        clipRect.setY(0.0);
        clipRect.widthProperty().bind((ObservableValue)this.widthProperty());
        clipRect.heightProperty().bind((ObservableValue)this.heightProperty());
        this.setClip((Node)clipRect);
        this.pinned = new SimpleBooleanProperty(true);
        this.pinned.addListener(e -> this.requestLayout());
        this.contentClassPane = new StackPane();
        this.contentClassPane.setId("slider-pane-glasspane");
        this.contentWrapper = new Pane(){

            protected void layoutChildren() {
                super.layoutChildren();
                if (SliderPane.this.content.get() != null) {
                    ((Node)SliderPane.this.content.get()).resize(SliderPane.this.contentWrapper.getWidth(), SliderPane.this.contentWrapper.getHeight());
                    ((Node)SliderPane.this.content.get()).relocate(0.0, 0.0);
                }
                SliderPane.this.contentClassPane.relocate(0.0, 0.0);
                SliderPane.this.contentClassPane.resize(SliderPane.this.contentWrapper.getWidth(), SliderPane.this.contentWrapper.getHeight());
            }

            protected double computePrefWidth(double height) {
                if (SliderPane.this.content.get() != null) {
                    return ((Node)SliderPane.this.content.get()).prefWidth(height);
                }
                return super.computePrefWidth(height);
            }
        };
        this.popoverWrapper = new Pane(){

            protected void layoutChildren() {
                super.layoutChildren();
                if (SliderPane.this.popover.get() != null) {
                    ((Node)SliderPane.this.popover.get()).resize(SliderPane.this.popoverWrapper.getWidth() - SliderPane.this.popoverWrapper.getPadding().getLeft() - SliderPane.this.popoverWrapper.getPadding().getRight(), SliderPane.this.popoverWrapper.getHeight() - SliderPane.this.popoverWrapper.getPadding().getTop() - SliderPane.this.popoverWrapper.getPadding().getBottom());
                    ((Node)SliderPane.this.popover.get()).relocate(SliderPane.this.popoverWrapper.getPadding().getLeft(), SliderPane.this.popoverWrapper.getPadding().getTop());
                }
            }

            protected double computePrefWidth(double height) {
                double popoverWidth = 0.0;
                if (SliderPane.this.popover.get() != null) {
                    return SliderPane.this.popoverWrapper.getPadding().getLeft() + ((Node)SliderPane.this.popover.get()).prefWidth(height) + SliderPane.this.popoverWrapper.getPadding().getRight();
                }
                return super.computePrefWidth(height);
            }
        };
        this.popoverWrapper.getStyleClass().add((Object)"slider-pane-popup");
        this.popupVisiblePercents = new SimpleDoubleProperty();
        this.popoverWrapper.translateXProperty().bind((ObservableValue)this.popoverWrapper.widthProperty().multiply((ObservableNumberValue)this.popupVisiblePercents).negate());
        this.content = new SimpleObjectProperty();
        this.popover = new SimpleObjectProperty();
        InvalidationListener contentListener = e -> {
            this.popoverWrapper.getChildren().clear();
            this.contentWrapper.getChildren().clear();
            this.getChildren().clear();
            if (this.content.get() != null) {
                this.contentWrapper.getChildren().add(this.content.get());
                this.getChildren().addAll((Object[])new Node[]{this.contentWrapper, this.contentClassPane});
            }
            if (this.popover.get() != null) {
                this.popoverWrapper.getChildren().add(this.popover.get());
                this.getChildren().add((Object)this.popoverWrapper);
            }
        };
        this.content.addListener(contentListener);
        this.popover.addListener(contentListener);
        this.pinned.addListener(e -> {
            if (this.pinned.get()) {
                if (this.mouseEnteredTransition != null) {
                    this.mouseEnteredTransition.stop();
                }
                if (this.mouseExitTransition != null) {
                    this.mouseExitTransition.stop();
                }
                this.popupVisiblePercents.unbind();
                this.popupVisiblePercents.set(0.0);
                if (this.popover.get() != null) {
                    ((Node)this.popover.get()).setOpacity(1.0);
                }
            }
        });
        this.popoverVisible = new SimpleBooleanProperty();
        this.popoverVisible.bind((ObservableValue)this.popupVisiblePercents.isEqualTo(0));
        this.popoverWrapper.visibleProperty().bind((ObservableValue)this.popupVisiblePercents.isEqualTo(1).not());
        this.contentClassPane.opacityProperty().bind((ObservableValue)this.popupVisiblePercents.negate().add(1.0));
        this.contentClassPane.visibleProperty().bind((ObservableValue)this.popupVisiblePercents.isEqualTo(1).not());
        this.contentClassPane.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> this.hidePopover());
        this.contentClassPane.addEventFilter(TouchEvent.TOUCH_PRESSED, e -> this.hidePopover());
        this.addEventFilter(SwipeEvent.SWIPE_RIGHT, e -> this.showPopover());
        this.addEventFilter(SwipeEvent.SWIPE_LEFT, e -> this.hidePopover());
        this.popupVisiblePercents.setValue((Number)1);
    }

    public void showPopover() {
        this.popupVisiblePercents.unbind();
        if (this.mouseExitTransition != null) {
            this.mouseExitTransition.stop();
        }
        BindableTransition slideAnimation = new BindableTransition(Duration.seconds((double)this.slideInDuration));
        slideAnimation.setStartValue(this.popupVisiblePercents.doubleValue());
        slideAnimation.setEndValue(0.0);
        this.popupVisiblePercents.bind((ObservableValue)slideAnimation.fractionProperty());
        this.mouseEnteredTransition = new ParallelTransition();
        this.mouseEnteredTransition.getChildren().add((Object)slideAnimation);
        this.mouseEnteredTransition.setCycleCount(1);
        this.mouseEnteredTransition.setInterpolator(Interpolator.EASE_OUT);
        if (this.popover.get() != null) {
            FadeTransition fadeTransition2 = new FadeTransition(slideAnimation.getTotalDuration());
            fadeTransition2.setFromValue(((Node)this.popover.get()).getOpacity());
            fadeTransition2.setToValue(1.0);
            fadeTransition2.setNode((Node)this.popover.get());
            this.mouseEnteredTransition.getChildren().add((Object)fadeTransition2);
        }
        this.mouseEnteredTransition.play();
    }

    public void hidePopover() {
        this.popupVisiblePercents.unbind();
        if (this.mouseEnteredTransition != null) {
            this.mouseEnteredTransition.stop();
        }
        BindableTransition slideAnimation = new BindableTransition(Duration.seconds((double)this.slideOutDuration));
        slideAnimation.setStartValue(this.popupVisiblePercents.doubleValue());
        this.popupVisiblePercents.bind((ObservableValue)slideAnimation.fractionProperty());
        this.mouseExitTransition = new ParallelTransition();
        this.mouseExitTransition.getChildren().add((Object)slideAnimation);
        this.mouseExitTransition.setCycleCount(1);
        this.mouseExitTransition.setInterpolator(Interpolator.EASE_IN);
        if (this.popover.get() != null) {
            FadeTransition fadeTransition2 = new FadeTransition(slideAnimation.getTotalDuration());
            fadeTransition2.setFromValue(((Node)this.popover.get()).getOpacity());
            fadeTransition2.setToValue(0.0);
            fadeTransition2.setNode((Node)this.popover.get());
            this.mouseExitTransition.getChildren().add((Object)fadeTransition2);
        }
        this.mouseExitTransition.play();
    }

    public boolean getPinned() {
        return this.pinned.get();
    }

    public BooleanProperty pinnedProperty() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned.set(pinned);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        double prefWidth = this.popoverWrapper.prefWidth(this.getHeight());
        this.popoverWrapper.resize(Math.min(prefWidth, this.getWidth() - 64.0), this.getHeight());
        this.popoverWrapper.relocate(0.0, 0.0);
        Node contentNode = (Node)this.content.get();
        if (this.pinned.get()) {
            this.contentWrapper.resize(this.getWidth() - this.getPadding().getLeft() - this.getPadding().getRight() - this.popoverWrapper.getWidth(), this.getHeight() - this.getPadding().getTop() - this.getPadding().getBottom());
            this.contentWrapper.relocate(this.popoverWrapper.getWidth() + this.getPadding().getLeft(), this.getPadding().getTop());
        } else {
            this.contentWrapper.resize(this.getWidth() - this.getPadding().getLeft() - this.getPadding().getRight(), this.getHeight() - this.getPadding().getTop() - this.getPadding().getBottom());
            this.contentWrapper.relocate(this.getPadding().getLeft(), this.getPadding().getTop());
        }
    }

    protected double computeMinWidth(double height) {
        if (this.content.get() != null) {
            return ((Node)this.content.get()).minWidth(height) + this.getPadding().getLeft() + this.getPadding().getRight();
        }
        return super.computeMinWidth(height);
    }

    protected double computeMinHeight(double width) {
        if (this.content.get() != null) {
            return ((Node)this.content.get()).minHeight(width) + this.getPadding().getTop() + this.getPadding().getBottom();
        }
        return super.computeMinHeight(width);
    }

    protected double computePrefWidth(double height) {
        if (!this.pinned.get()) {
            if (this.content.get() != null) {
                return ((Node)this.content.get()).prefWidth(height) + this.getPadding().getLeft() + this.getPadding().getRight();
            }
        } else {
            double contentWidth = 0.0;
            if (this.content.get() != null) {
                contentWidth = ((Node)this.content.get()).prefWidth(height) + this.getPadding().getLeft() + this.getPadding().getRight();
            }
            return this.popoverWrapper.getWidth() + contentWidth;
        }
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        if (this.content.get() != null) {
            return ((Node)this.content.get()).prefHeight(width) + this.getPadding().getTop() + this.getPadding().getBottom();
        }
        return super.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        if (!this.pinned.get()) {
            if (this.content.get() != null) {
                return ((Node)this.content.get()).maxWidth(height) + this.getPadding().getLeft() + this.getPadding().getRight();
            }
        } else {
            double contentWidth = 0.0;
            if (this.content.get() != null) {
                contentWidth = ((Node)this.content.get()).maxWidth(height) + this.getPadding().getLeft() + this.getPadding().getRight();
            }
            return this.popoverWrapper.getWidth() + contentWidth;
        }
        return super.computeMaxWidth(height);
    }

    protected double computeMaxHeight(double width) {
        if (this.content.get() != null) {
            return ((Node)this.content.get()).maxHeight(width) + this.getPadding().getTop() + this.getPadding().getBottom();
        }
        return super.computeMaxHeight(width);
    }

    public Node getContent() {
        return (Node)this.content.get();
    }

    public ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public void setContent(Node content) {
        this.content.set((Object)content);
    }

    public boolean isPopoverVisible() {
        return this.popoverVisible.get();
    }

    public BooleanProperty popoverVisibleProperty() {
        return this.popoverVisible;
    }

    public void setPopoverVisible(boolean popoverVisible) {
        this.popoverVisible.set(popoverVisible);
    }

    public Node getPopover() {
        return (Node)this.popover.get();
    }

    public ObjectProperty<Node> popoverProperty() {
        return this.popover;
    }

    public void setPopover(Node popover) {
        this.popover.set((Object)popover);
    }
}

