/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.util;

import com.guigarage.sdk.util.RoundImageView;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;

public class RoundImageViewSkin
extends SkinBase<RoundImageView> {
    private Circle circleClip;
    private Circle overlayCircle;
    private ImageView imageView = new ImageView();

    public RoundImageViewSkin(RoundImageView control) {
        super((Control)control);
        this.imageView.setPreserveRatio(true);
        this.imageView.setSmooth(true);
        this.circleClip = new Circle();
        this.imageView.setClip((Node)this.circleClip);
        this.overlayCircle = new Circle();
        this.overlayCircle.getStyleClass().add((Object)"round-image-view-circle");
        this.overlayCircle.setFill((Paint)Color.TRANSPARENT);
        this.getChildren().add((Object)this.imageView);
        this.getChildren().add((Object)this.overlayCircle);
        this.imageView.imageProperty().bind(((RoundImageView)this.getSkinnable()).imageProperty());
        ((RoundImageView)this.getSkinnable()).setMaxWidth(Double.NEGATIVE_INFINITY);
        ((RoundImageView)this.getSkinnable()).setMinWidth(Double.NEGATIVE_INFINITY);
        ((RoundImageView)this.getSkinnable()).setMaxHeight(Double.NEGATIVE_INFINITY);
        ((RoundImageView)this.getSkinnable()).setMinHeight(Double.NEGATIVE_INFINITY);
    }

    protected double computeSize() {
        return ((RoundImageView)this.getSkinnable()).defaultSizeProperty().doubleValue();
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computeSize() + topInset + bottomInset;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computeSize() + leftInset + topInset;
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        if (contentHeight > contentWidth) {
            contentY += (contentHeight - contentWidth) / 2.0;
            contentHeight = contentWidth;
        } else {
            contentX += (contentWidth - contentHeight) / 2.0;
            contentWidth = contentHeight;
        }
        this.overlayCircle.setCenterX(contentX + contentWidth / 2.0);
        this.overlayCircle.setCenterY(contentY + contentHeight / 2.0);
        this.overlayCircle.setRadius(contentHeight / 2.0);
        this.imageView.relocate(contentX, contentY);
        this.imageView.resize(contentWidth, contentHeight);
        if (this.imageView.getImage() != null) {
            Image currentImage = this.imageView.getImage();
            this.circleClip.setCenterX(contentWidth / 2.0);
            if (currentImage.getHeight() > currentImage.getWidth()) {
                this.imageView.setFitWidth(contentWidth);
                this.imageView.setFitHeight(-1.0);
                double factor = currentImage.getWidth() / contentWidth;
                this.imageView.setViewport(new Rectangle2D(0.0, (currentImage.getHeight() - contentHeight * factor) / 2.0, currentImage.getWidth(), currentImage.getHeight()));
            } else {
                this.imageView.setFitHeight(contentHeight);
                this.imageView.setFitWidth(-1.0);
                double factor = currentImage.getHeight() / contentHeight;
                this.imageView.setViewport(new Rectangle2D((currentImage.getWidth() - contentWidth * factor) / 2.0, 0.0, currentImage.getWidth(), currentImage.getHeight()));
            }
            this.circleClip.setCenterY(contentWidth / 2.0);
            this.circleClip.setRadius(contentWidth / 2.0);
        }
    }
}

